/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.transactions;

import com.dataiku.dip.transactions.exceptions.TransactionContextError;
import com.dataiku.dip.transactions.ifaces.RWTransactionRef;
import com.dataiku.dip.transactions.ifaces.TransactionRef;
import com.dataiku.dip.transactions.ifaces.TransactionScope;
import com.dataiku.dip.utils.DKULogger;

public class TransactionContext {
    private static ThreadLocal<TransactionRef> currentTransaction = new ThreadLocal();
    private static DKULogger logger = DKULogger.getLogger((String)"dku.transactions.context");

    public static TransactionRef retrieveRead() throws TransactionContextError {
        TransactionRef current = currentTransaction.get();
        if (current == null) {
            throw new TransactionContextError("The current thread has no associated transaction");
        }
        if (!current.isAlive()) {
            throw new TransactionContextError("The current thread has no associated transaction, or it has been closed");
        }
        return current;
    }

    public static RWTransactionRef retrieveWrite() throws TransactionContextError {
        TransactionRef current = currentTransaction.get();
        if (current == null) {
            throw new TransactionContextError("The current thread has no associated transaction");
        }
        if (!(current instanceof RWTransactionRef)) {
            throw new TransactionContextError("The transaction associated to the current thread is read-only");
        }
        if (!current.isAlive()) {
            throw new TransactionContextError("The transaction associated to the current thread has been closed");
        }
        return (RWTransactionRef)current;
    }

    public static boolean hasAttachedTransaction() {
        TransactionRef current = currentTransaction.get();
        return current != null && current.isAlive();
    }

    public static boolean hasAttachedRWTransaction() {
        TransactionRef current = currentTransaction.get();
        return current != null && current.isAlive() && current instanceof RWTransactionRef;
    }

    public static void assertNoAttachedTransaction() {
        if (TransactionContext.hasAttachedTransaction()) {
            throw new TransactionContextError("Another alive transaction is already attached to the current thread: " + String.valueOf(TransactionContext.retrieveRead()));
        }
    }

    public static void assertAttachedTransaction() {
        if (!TransactionContext.hasAttachedTransaction()) {
            throw new TransactionContextError("Expected to have an active transaction");
        }
    }

    public static void assertAttachedRWTransaction() {
        if (!TransactionContext.hasAttachedRWTransaction()) {
            throw new TransactionContextError("Expected to have an active RW transaction");
        }
    }

    public static void warnAttachedTransaction() {
        if (TransactionContext.hasAttachedTransaction()) {
            TransactionRef current = currentTransaction.get();
            logger.warn((Object)("Expected a no-transaction context but had a " + (current instanceof RWTransactionRef ? "WRITE" : "READ") + " transaction"), (Throwable)new Exception());
        }
    }

    public static void attach(TransactionRef t) throws TransactionContextError {
        if (t == null || !t.isAlive()) {
            throw new IllegalArgumentException("Invalid transaction, trying to attach: " + String.valueOf(t));
        }
        TransactionRef current = currentTransaction.get();
        if (current == t) {
            return;
        }
        if (TransactionContext.hasAttachedTransaction()) {
            throw new TransactionContextError("Another alive transaction is already attached to the current thread");
        }
        currentTransaction.set(t);
    }

    public static void detach(TransactionRef t) throws TransactionContextError {
        if (t == null) {
            throw new IllegalArgumentException("Invalid transaction");
        }
        TransactionRef existing = currentTransaction.get();
        if (t != existing) {
            throw new TransactionContextError("The transaction was not attached to the current thread");
        }
        currentTransaction.set(null);
    }

    public static TransactionScope with(final TransactionRef t) {
        TransactionContext.attach(t);
        return new TransactionScope(){

            @Override
            public void close() {
                TransactionContext.detach(t);
            }
        };
    }
}

