/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.transactions.fs.utils;

import com.dataiku.dip.transactions.fs.NativeFS;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.fs.ifaces.ReadOnlyFS;
import com.dataiku.dip.transactions.fs.ifaces.ReadWriteFS;
import com.dataiku.dip.transactions.fs.ifaces.RelFileAttribute;
import com.dataiku.dip.transactions.fs.utils.AcceptAllFilter;
import com.dataiku.dip.transactions.fs.utils.RelFileFilter;
import com.dataiku.dip.transactions.fs.utils.copy.CompressedBytesRefCopyMethod;
import com.dataiku.dip.transactions.fs.utils.copy.CopyMethod;
import com.dataiku.dip.transactions.fs.utils.copy.FileContentRefCopyMethod;
import com.dataiku.dip.transactions.fs.utils.copy.ParallelizedCopyMethod;
import com.dataiku.dip.transactions.fs.utils.copy.RetriableCopyMethod;
import com.dataiku.dip.transactions.fs.utils.copy.SkipUnlessHashChangedCopyMethod;
import com.dataiku.dip.transactions.fs.utils.copy.StreamCopyMethod;
import java.io.File;
import java.io.IOException;
import java.util.TreeSet;
import java.util.function.Supplier;

public class FSUtils {
    public static final int BUFFER_SIZE = 65536;
    public static final Supplier<CopyMethod> COPY_STREAM = () -> new StreamCopyMethod();
    public static final Supplier<CopyMethod> COPY_COMPRESSED_BYTES_REF = CompressedBytesRefCopyMethod::new;
    public static final Supplier<CopyMethod> COPY_FILE_CONTENT_REF = FileContentRefCopyMethod::new;

    public static CopyBuilder newRecursiveCopy() {
        return new CopyBuilder().sync(false);
    }

    public static long calculateSize(ReadOnlyFS fs, RelFile path) throws IOException {
        return FSUtils.calculateSize(fs, path, new AcceptAllFilter());
    }

    public static long calculateSize(ReadOnlyFS fs, RelFile path, RelFileFilter filter) throws IOException {
        long total = 0L;
        for (RelFile rf : fs.listRecursive(path, filter)) {
            if (!fs.isFile(rf)) continue;
            total += fs.getLength(rf);
        }
        return total;
    }

    public static CopyBuilder newRecursiveSync() {
        return new CopyBuilder().sync(true);
    }

    public static class CopyBuilder {
        private ReadOnlyFS srcFS;
        private RelFile srcFile;
        private ReadWriteFS dstFS;
        private RelFile dstFile;
        private RelFileFilter filter = new AcceptAllFilter();
        private boolean performADryRunFirst = true;
        private Supplier<CopyMethod> copyMethodFactory = COPY_STREAM;
        private boolean sync = false;
        private int parallelism = 1;
        private int maxRetry = 0;
        private OverwriteMode overwriteMode;

        private CopyBuilder() {
        }

        public CopyBuilder from(ReadOnlyFS srcFS, RelFile srcFile) {
            this.srcFS = srcFS;
            this.srcFile = srcFile;
            return this;
        }

        public CopyBuilder from(ReadOnlyFS srcFS, String path) {
            return this.from(srcFS, RelFile.fromPath(path));
        }

        public CopyBuilder from(ReadOnlyFS srcFS) {
            return this.from(srcFS, RelFile.root());
        }

        public CopyBuilder from(File src) throws IOException {
            return this.from(NativeFS.from(src).build());
        }

        public CopyBuilder overwriteMode(OverwriteMode overwriteMode) {
            this.overwriteMode = overwriteMode;
            return this;
        }

        public CopyBuilder filter(RelFileFilter filter) {
            this.filter = this.filter.and(filter);
            return this;
        }

        public CopyBuilder dryRun(boolean performADryRunFirst) {
            this.performADryRunFirst = performADryRunFirst;
            return this;
        }

        public CopyBuilder copyMethod(Supplier<CopyMethod> copyMethodFactory) {
            this.copyMethodFactory = copyMethodFactory;
            return this;
        }

        private CopyBuilder sync(boolean sync) {
            this.sync = sync;
            return this;
        }

        public CopyBuilder parallelism(int parallelism) {
            this.parallelism = parallelism;
            return this;
        }

        public CopyBuilder maxRetry(int maxRetry) {
            this.maxRetry = maxRetry;
            return this;
        }

        public CopyBuilder to(ReadWriteFS dstFS, RelFile dstFile) throws IOException {
            this.dstFS = dstFS;
            this.dstFile = dstFile;
            return this;
        }

        public CopyBuilder to(ReadWriteFS dstFS) throws IOException {
            return this.to(dstFS, RelFile.root());
        }

        public CopyBuilder to(ReadWriteFS dstFS, String path) throws IOException {
            return this.to(dstFS, RelFile.fromPath(path));
        }

        private static Supplier<CopyMethod> enhanceCopyMethodToSkipOverwriteUnlessHashChanged(Supplier<CopyMethod> copyMethodSupplier) {
            return () -> new SkipUnlessHashChangedCopyMethod((CopyMethod)copyMethodSupplier.get());
        }

        private static Supplier<CopyMethod> enhanceCopyMethodToAddRetry(Supplier<CopyMethod> copyMethodSupplier, int maxRetry) {
            return () -> new RetriableCopyMethod((CopyMethod)copyMethodSupplier.get(), maxRetry);
        }

        private static Supplier<CopyMethod> enhanceCopyMethodToAddParallelism(Supplier<CopyMethod> copyMethodSupplier, int nbThreads, int queueSize) {
            return () -> new ParallelizedCopyMethod(nbThreads, queueSize, copyMethodSupplier);
        }

        public CopyStats run() throws IOException {
            Supplier<CopyMethod> actualCopyMethodFactory = this.copyMethodFactory;
            if (this.overwriteMode == OverwriteMode.SKIP_UNLESS_HASH_CHANGED) {
                actualCopyMethodFactory = CopyBuilder.enhanceCopyMethodToSkipOverwriteUnlessHashChanged(actualCopyMethodFactory);
            }
            if (this.maxRetry > 0) {
                actualCopyMethodFactory = CopyBuilder.enhanceCopyMethodToAddRetry(actualCopyMethodFactory, this.maxRetry);
            }
            if (this.parallelism > 1) {
                actualCopyMethodFactory = CopyBuilder.enhanceCopyMethodToAddParallelism(actualCopyMethodFactory, this.parallelism, 100);
            }
            try (CopyMethod copyMethod = actualCopyMethodFactory.get();){
                if (this.sync) {
                    if (!this.dstFile.isRoot()) {
                        this.dstFS.makeDirectory(this.dstFile.getParent());
                    }
                    this.recursiveSyncInternal(this.srcFile, this.dstFile, copyMethod, true);
                } else {
                    if (this.performADryRunFirst) {
                        this.recursiveCopyInternal(this.srcFile, this.dstFile, true, copyMethod, true);
                    }
                    if (!this.dstFile.isRoot()) {
                        this.dstFS.makeDirectory(this.dstFile.getParent());
                    }
                    this.recursiveCopyInternal(this.srcFile, this.dstFile, true, copyMethod, false);
                }
            }
            return copyMethod.getStats();
        }

        private void recursiveSyncInternal(RelFile curSrcFile, RelFile curDstFile, CopyMethod copyMethod, boolean checkDestinationExistence) throws IOException {
            RelFileAttribute srcAttr = this.filter.accept(this.srcFS, curSrcFile) ? this.srcFS.getAttributes(curSrcFile) : null;
            RelFileAttribute dstAttr = checkDestinationExistence ? this.dstFS.getAttributes(curDstFile) : null;
            boolean syncDirectoryContent = false;
            if (srcAttr == null && dstAttr != null) {
                if (dstAttr.getFileType() == RelFileAttribute.FileType.FILE) {
                    this.dstFS.deleteFile(curDstFile);
                } else if (dstAttr.getFileType() == RelFileAttribute.FileType.DIRECTORY) {
                    this.dstFS.deleteDirectory(curDstFile);
                }
            }
            if (srcAttr != null && dstAttr == null) {
                if (srcAttr.getFileType() == RelFileAttribute.FileType.DIRECTORY) {
                    this.dstFS.makeDirectory(curDstFile);
                    syncDirectoryContent = true;
                    checkDestinationExistence = false;
                } else if (srcAttr.getFileType() == RelFileAttribute.FileType.FILE) {
                    copyMethod.copyFile(this.srcFS, curSrcFile, srcAttr, this.dstFS, curDstFile, null);
                }
            }
            if (srcAttr != null && dstAttr != null) {
                if (srcAttr.getFileType() == RelFileAttribute.FileType.FILE) {
                    if (dstAttr.getFileType() == RelFileAttribute.FileType.DIRECTORY) {
                        this.dstFS.deleteDirectory(curDstFile);
                        copyMethod.copyFile(this.srcFS, curSrcFile, srcAttr, this.dstFS, curDstFile, null);
                    } else if (dstAttr.getFileType() == RelFileAttribute.FileType.FILE) {
                        copyMethod.copyFile(this.srcFS, curSrcFile, srcAttr, this.dstFS, curDstFile, dstAttr);
                    }
                }
                if (srcAttr.getFileType() == RelFileAttribute.FileType.DIRECTORY) {
                    if (dstAttr.getFileType() == RelFileAttribute.FileType.FILE) {
                        this.dstFS.deleteFile(curDstFile);
                        this.dstFS.makeDirectory(curDstFile);
                        checkDestinationExistence = false;
                    }
                    syncDirectoryContent = true;
                }
            }
            if (syncDirectoryContent) {
                TreeSet<String> filenamesToUpdate = new TreeSet<String>();
                for (RelFile srf : this.srcFS.listFilesUnordered(curSrcFile)) {
                    filenamesToUpdate.add(srf.getLeafName());
                }
                for (RelFile drf : this.dstFS.listFilesUnordered(curDstFile)) {
                    filenamesToUpdate.add(drf.getLeafName());
                }
                for (String filenameToUpdate : filenamesToUpdate) {
                    this.recursiveSyncInternal(curSrcFile.append(filenameToUpdate), curDstFile.append(filenameToUpdate), copyMethod, checkDestinationExistence);
                }
            }
        }

        private void recursiveCopyInternal(RelFile curSrcFile, RelFile curDstFile, boolean checkDestinationExistence, CopyMethod copyMethod, boolean simulate) throws IOException {
            if (this.filter.accept(this.srcFS, curSrcFile)) {
                RelFileAttribute dstAttr = checkDestinationExistence ? this.dstFS.getAttributes(curDstFile) : null;
                RelFileAttribute srcAttr = this.srcFS.getAttributes(curSrcFile);
                if (srcAttr != null && srcAttr.getFileType() == RelFileAttribute.FileType.DIRECTORY) {
                    if (dstAttr != null && dstAttr.getFileType() == RelFileAttribute.FileType.FILE) {
                        throw new IOException("Unable to create directory " + String.valueOf(curDstFile) + ", because it already exists as a file");
                    }
                    if (!simulate) {
                        this.dstFS.makeDirectory(curDstFile);
                    }
                    for (RelFile srf : this.srcFS.listFilesUnordered(curSrcFile)) {
                        RelFile drf = curDstFile.append(srf.getLeafName());
                        this.recursiveCopyInternal(srf, drf, dstAttr != null, copyMethod, simulate);
                    }
                } else if (srcAttr != null && srcAttr.getFileType() == RelFileAttribute.FileType.FILE) {
                    if (dstAttr != null && dstAttr.getFileType() == RelFileAttribute.FileType.DIRECTORY) {
                        throw new IOException("Unable to create/truncate file " + String.valueOf(curDstFile) + ", because it already exists as a directory");
                    }
                    if (!simulate) {
                        copyMethod.copyFile(this.srcFS, curSrcFile, srcAttr, this.dstFS, curDstFile, dstAttr);
                    }
                } else {
                    throw new IOException(String.valueOf(curSrcFile) + " doesn't exist in source");
                }
            }
        }
    }

    public static class CopyStats {
        public int nbFilesCopied;
        public int nbFilesSkipped;

        public CopyStats aggregate(CopyStats other) {
            CopyStats result = new CopyStats();
            result.nbFilesCopied = this.nbFilesCopied + other.nbFilesCopied;
            result.nbFilesSkipped = this.nbFilesSkipped + other.nbFilesSkipped;
            return result;
        }
    }

    public static enum OverwriteMode {
        ALWAYS_OVERWRITE,
        SKIP_UNLESS_HASH_CHANGED;

    }
}

