/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.transactions.utils;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.mutable.MutableObject;

public class InterfaceCombiner {
    private List<Implementation> implementations = new ArrayList<Implementation>();

    public <T> InterfaceCombiner add(T obj) {
        return this.add(obj, null);
    }

    public <T> InterfaceCombiner add(T obj, Hook hook) {
        Implementation impl = new Implementation();
        impl.implementation = obj;
        impl.hook = hook == null ? new Hook() : hook;
        this.implementations.add(impl);
        return this;
    }

    private static LinkageError throwMissingImplementationException(Method method) throws LinkageError {
        ArrayList<String> types = new ArrayList<String>();
        for (Class<?> c : method.getParameterTypes()) {
            types.add(c.getSimpleName());
        }
        return new LinkageError("No implementation provided for method " + method.getName() + "(" + StringUtils.join(types, (String)", ") + ") of interface " + method.getDeclaringClass().getName());
    }

    public <I> I as(Class<I> iface) {
        if (!iface.isInterface()) {
            throw new LinkageError(iface.getName() + " is not an interface");
        }
        final ArrayList<Implementation> copy = new ArrayList<Implementation>(this.implementations);
        for (Method m : iface.getMethods()) {
            boolean found = false;
            for (Implementation o : copy) {
                if (!m.getDeclaringClass().isInstance(o.implementation)) continue;
                found = true;
            }
            if (found) continue;
            throw InterfaceCombiner.throwMissingImplementationException(m);
        }
        return (I)Proxy.newProxyInstance(iface.getClassLoader(), new Class[]{iface}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, final Method method, final Object[] args) throws Throwable {
                for (final Implementation o : copy) {
                    if (!method.getDeclaringClass().isInstance(o.implementation)) continue;
                    final MutableObject returnValue = new MutableObject();
                    o.hook.hook(new Hook.HookedCall(){

                        @Override
                        public Method getMethod() {
                            return method;
                        }

                        @Override
                        public void doCall() throws Throwable {
                            try {
                                returnValue.setValue(method.invoke(o.implementation, args));
                            }
                            catch (InvocationTargetException e) {
                                throw e.getCause();
                            }
                        }
                    });
                    return returnValue.getValue();
                }
                throw InterfaceCombiner.throwMissingImplementationException(method);
            }
        });
    }

    public static class Hook {
        public void hook(HookedCall invokeMe) throws Throwable {
            invokeMe.doCall();
        }

        public static interface HookedCall {
            public Method getMethod();

            public void doCall() throws Throwable;
        }
    }

    private static class Implementation {
        private Object implementation;
        private Hook hook;

        private Implementation() {
        }
    }
}

