/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.utils;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.dataiku.dip.DKUApp;
import com.dataiku.dip.DSSMetrics;
import com.dataiku.dip.utils.DKULogger;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;

public abstract class AbstractBoundedQueueHandler<T> {
    private final BlockingQueue<PendingTask<T>> queue;
    private final String threadName;
    private final String prefixForMetrics;
    private final ProcessingThread pt;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.pubsub");

    public AbstractBoundedQueueHandler(String maxQueuePropertyName, int defaultMaxQueue, String threadName, String prefixForMetrics) {
        int queueMax = DKUApp.getParams().getIntParam(maxQueuePropertyName, Integer.valueOf(defaultMaxQueue));
        this.queue = new LinkedBlockingQueue<PendingTask<T>>(queueMax);
        this.threadName = threadName;
        this.prefixForMetrics = prefixForMetrics;
        this.pt = new ProcessingThread();
        this.pt.start();
        DSSMetrics.registry().register(prefixForMetrics + ".queueSize", (Metric)((Gauge)this.queue::size));
    }

    protected abstract void process(T var1) throws Exception;

    public void clear() {
        logger.info((Object)"Clearing tasks queue");
        this.queue.clear();
    }

    public void enqueueOrFail(T t) throws IllegalStateException {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Enqueue task " + String.valueOf(t)));
        }
        PendingTask pt = new PendingTask();
        pt.submitTS = System.currentTimeMillis();
        pt.payload = t;
        try {
            this.queue.add(pt);
            DSSMetrics.registry().meter(this.prefixForMetrics + ".enqueuedTasks").mark();
        }
        catch (IllegalStateException e) {
            DSSMetrics.registry().meter(this.prefixForMetrics + ".droppedTasks").mark();
            throw e;
        }
    }

    public void enqueueIgnore(T t) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Enqueue task " + String.valueOf(t)));
        }
        PendingTask pt = new PendingTask();
        pt.submitTS = System.currentTimeMillis();
        pt.payload = t;
        boolean enqueued = this.queue.offer(pt);
        if (enqueued) {
            DSSMetrics.registry().meter(this.prefixForMetrics + ".enqueuedTasks").mark();
        } else {
            DSSMetrics.registry().meter(this.prefixForMetrics + ".droppedTasks").mark();
        }
    }

    class ProcessingThread
    extends Thread {
        ProcessingThread() {
            this.setName(AbstractBoundedQueueHandler.this.threadName);
        }

        @Override
        public void run() {
            while (true) {
                PendingTask task;
                logger.trace((Object)"Waiting for a task to run");
                try {
                    task = AbstractBoundedQueueHandler.this.queue.take();
                }
                catch (InterruptedException e) {
                    logger.warn((Object)"The bounded queue processing thread was interrupted, but it must stay alive, ignoring", (Throwable)e);
                    continue;
                }
                assert (task != null);
                long now = System.currentTimeMillis();
                long timeSpentInQueue = now - task.submitTS;
                if (timeSpentInQueue > 1000L) {
                    logger.debug((Object)("Running task (in the queue for " + timeSpentInQueue + "ms)"));
                } else {
                    logger.trace((Object)("Running task (in the queue for " + timeSpentInQueue + "ms)"));
                }
                try {
                    DSSMetrics.TimeCtx tctx = DSSMetrics.timeCtx(AbstractBoundedQueueHandler.this.prefixForMetrics + ".processTask");
                    try {
                        AbstractBoundedQueueHandler.this.process(task.payload);
                        long taskTime = System.currentTimeMillis() - now;
                        if (taskTime > 100L) {
                            logger.debug((Object)("Task done in " + taskTime + "ms"));
                            continue;
                        }
                        logger.trace((Object)("Task done in " + taskTime + "ms"));
                        continue;
                    }
                    finally {
                        if (tctx == null) continue;
                        tctx.close();
                        continue;
                    }
                }
                catch (Throwable t) {
                    logger.warn((Object)("Task failed in " + (System.currentTimeMillis() - now)), t);
                    continue;
                }
                break;
            }
        }
    }

    static class PendingTask<T> {
        long submitTS;
        T payload;

        PendingTask() {
        }
    }
}

