/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.utils.j3ts;

import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.j3ts.ClassScanner;
import com.dataiku.dip.utils.j3ts.TSMappedType;
import com.dataiku.j2ts.annotations.UIData;
import com.dataiku.j2ts.annotations.UIIgnore;
import com.dataiku.j2ts.annotations.UIModel;
import com.dataiku.j2ts.annotations.UINullable;
import com.dataiku.j2ts.annotations.UIType;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.internal.;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public class TSTypeMapper {
    private final ClassScanner classScanner;
    private final List<TSMappedType.ForeignMapping> foreignMappings;
    private final Map<Type, TSMappedType> localMappings = new HashMap<Type, TSMappedType>();
    private final HashMap<Class<?>, String> customMappings;
    private TSMappedType currentTranslatedVia;
    private int currentTranslatedViaDepth;

    public TSTypeMapper(ClassScanner classScanner, List<TSMappedType.ForeignMapping> foreignMapping, HashMap<Class<?>, String> customMappings) {
        this.classScanner = classScanner;
        this.foreignMappings = foreignMapping;
        this.customMappings = customMappings;
    }

    public List<TSMappedType> getAllMappedTypes() {
        ArrayList<TSMappedType> out = new ArrayList<TSMappedType>(this.localMappings.values());
        out.sort(Comparator.comparing(mt -> mt.javaType.getTypeName()));
        return out;
    }

    private void inspectType(TSMappedType mt) throws Exception {
        if (mt.inspected) {
            return;
        }
        mt.inspected = true;
        if (mt.javaType instanceof Class) {
            Class clazz = (Class)mt.javaType;
            String javaClassName = clazz.getName();
            if (clazz.isAnonymousClass()) {
                mt.tsType = TSMappedType.TSType.UNKNOWN;
                mt.problem = clazz.getName();
                return;
            }
            mt.polyJsonMeta = JSON.getPolyJsonMeta((Class)clazz);
            for (TSMappedType.ForeignMapping foreignMapping : this.foreignMappings) {
                Class[] typeMeta = foreignMapping.javaToTs.get(javaClassName);
                if (typeMeta == null) continue;
                mt.tsType = typeMeta.tsType;
                mt.tsName = typeMeta.tsName;
                mt.tsDefinitionFileNoExt = RelFile.fromPath(typeMeta.tsDefinitionFileNoExt);
                mt.tsNamespaces = typeMeta.tsNamespaces;
                mt.foreignMapping = foreignMapping;
                return;
            }
            for (Class curClass = clazz; curClass != null; curClass = curClass.getSuperclass()) {
                UIType uiType = curClass.getAnnotation(UIType.class);
                if (uiType != null) {
                    mt.tsType = TSMappedType.TSType.CUSTOM;
                    mt.tsCustomType = uiType.value();
                    mt.problem = clazz.getName() + " (overridden)";
                    for (Class manualImport : uiType.manualImports()) {
                        mt.manualImports.add(this.mapType(manualImport));
                    }
                    return;
                }
                String customMapping = this.customMappings.get(curClass);
                if (customMapping == null) continue;
                mt.tsType = TSMappedType.TSType.CUSTOM;
                mt.tsCustomType = customMapping;
                mt.problem = clazz.getName() + " (overridden)";
                return;
            }
            if (CharSequence.class.isAssignableFrom(clazz) || Character.TYPE == clazz || Character.class == clazz) {
                mt.tsType = TSMappedType.TSType.STRING;
            } else if (Number.class.isAssignableFrom(clazz) || Double.TYPE == clazz || Integer.TYPE == clazz || Long.TYPE == clazz || Short.TYPE == clazz || Byte.TYPE == clazz || Float.TYPE == clazz || Double.class == clazz || Integer.class == clazz || Long.class == clazz || Short.class == clazz || Byte.class == clazz || Float.class == clazz) {
                mt.tsType = TSMappedType.TSType.NUMBER;
            } else if (Object.class == clazz) {
                mt.tsType = TSMappedType.TSType.ANY;
                mt.problem = clazz.getName();
            } else if (Boolean.class == clazz || Boolean.TYPE == clazz) {
                mt.tsType = TSMappedType.TSType.BOOLEAN;
            } else if (mt.javaType == JsonObject.class || Map.class.isAssignableFrom(clazz)) {
                mt.tsType = TSMappedType.TSType.MAP;
                mt.typeParameters = Lists.newArrayList((Object[])new TSMappedType[]{this.mapType((Type)((Object)String.class)), this.mapType((Type)((Object)JsonElement.class))});
            } else if (mt.javaType == JsonArray.class || Collection.class.isAssignableFrom(clazz)) {
                mt.tsType = TSMappedType.TSType.LIST;
                mt.typeParameters = Lists.newArrayList((Object[])new TSMappedType[]{this.mapType((Type)((Object)JsonElement.class))});
            } else if (JsonElement.class.isAssignableFrom(clazz)) {
                mt.tsType = TSMappedType.TSType.ANY;
                mt.problem = clazz.getName();
            } else if (clazz.isArray()) {
                mt.tsType = TSMappedType.TSType.LIST;
                mt.typeParameters = Lists.newArrayList((Object[])new TSMappedType[]{this.mapType(clazz.getComponentType())});
            } else {
                Type sc;
                Field[] sortedFields;
                int idx;
                String javaNameInPackage;
                mt.tsName = clazz.getSimpleName();
                ClassScanner.RootMapping root = this.classScanner.getRootMappingForClass(clazz);
                if (root == null) {
                    mt.problem = clazz.getName() + " outside roots";
                    mt.logTranslationIssue("Class outside root");
                }
                String string = javaNameInPackage = (idx = javaClassName.lastIndexOf(".")) == -1 ? javaClassName : javaClassName.substring(idx + 1);
                if (javaNameInPackage.contains("$")) {
                    String[] parts = StringUtils.split((String)javaNameInPackage, (String)"$");
                    parts = Arrays.copyOf(parts, parts.length - 1);
                    mt.tsNamespaces.addAll(Arrays.asList(parts));
                }
                String javaPackageName = javaClassName.substring(0, javaClassName.length() - javaNameInPackage.length());
                String tsUnitName = mt.tsNamespaces.isEmpty() ? mt.tsName : mt.tsNamespaces.get(0);
                String tsFileName = tsUnitName.replaceAll("([A-Z]+)", "-$1").toLowerCase();
                if (tsFileName.startsWith("-")) {
                    tsFileName = tsFileName.substring(1);
                }
                RelFile tsFileDirectory = (root != null && root.targetDirectory != null ? root.targetDirectory : RelFile.root()).append(StringUtils.split((String)javaPackageName, (String)"."));
                mt.tsDefinitionFileNoExt = tsFileDirectory.append(tsFileName);
                mt.tsType = clazz.isEnum() ? TSMappedType.TSType.ENUM : TSMappedType.TSType.INTERFACE;
                UIModel uiModelAnnotation = clazz.getAnnotation(UIModel.class);
                if (uiModelAnnotation != null) {
                    mt.addToIndex = uiModelAnnotation.index();
                }
                for (Field field2 : sortedFields = (Field[])Arrays.stream(clazz.getDeclaredFields()).filter(field -> mt.polyJsonMeta == null || !Objects.equals(mt.polyJsonMeta.getTypeProperty(), field.getName())).filter(field -> !Modifier.isTransient(field.getModifiers()) && !field.isSynthetic()).sorted(Comparator.comparing(Field::getName).thenComparing(Field::getModifiers)).toArray(Field[]::new)) {
                    boolean hasUIData;
                    boolean isStatic = Modifier.isStatic(field2.getModifiers());
                    boolean bl = hasUIData = field2.getAnnotation(UIData.class) != null;
                    if (isStatic && !hasUIData || !isStatic && clazz.isEnum() || field2.getAnnotation(UIIgnore.class) != null) continue;
                    TSMappedType.MappedField mappedField = new TSMappedType.MappedField();
                    SerializedName serializedName = field2.getAnnotation(SerializedName.class);
                    mappedField.name = serializedName == null ? field2.getName() : serializedName.value();
                    Type fieldType = field2.getGenericType();
                    UIType uiType = field2.getAnnotation(UIType.class);
                    if (uiType == null) {
                        mappedField.mt = this.mapType(fieldType);
                        mappedField.optional = field2.getAnnotation(Nullable.class) != null || field2.getAnnotation(UINullable.class) != null;
                    } else {
                        mappedField.mt = new TSMappedType();
                        mappedField.mt.tsType = TSMappedType.TSType.CUSTOM;
                        mappedField.mt.javaType = fieldType;
                        mappedField.mt.tsCustomType = uiType.value();
                        mappedField.mt.problem = "Overridden type";
                        mappedField.optional = false;
                        for (Class manualImport : uiType.manualImports()) {
                            mappedField.mt.manualImports.add(this.mapType(manualImport));
                        }
                    }
                    if (isStatic) {
                        mappedField.tsData = JSON.stablePrettyJson((Object)field2.get(null));
                        if (mt.uiDataFields == null) {
                            mt.uiDataFields = new ArrayList<TSMappedType.MappedField>();
                        }
                        mt.uiDataFields.add(mappedField);
                        continue;
                    }
                    if (mt.typeFields == null) {
                        mt.typeFields = new ArrayList<TSMappedType.MappedField>();
                    }
                    mt.typeFields.add(mappedField);
                }
                if (uiModelAnnotation != null) {
                    for (Field field3 : uiModelAnnotation.extraFields()) {
                        TSMappedType.MappedField mappedField = new TSMappedType.MappedField();
                        mappedField.name = field3.name();
                        mappedField.mt = new TSMappedType();
                        mappedField.mt.tsType = TSMappedType.TSType.CUSTOM;
                        mappedField.mt.tsCustomType = field3.value();
                        for (Class manualImport : field3.manualImports()) {
                            mappedField.mt.manualImports.add(this.mapType(manualImport));
                        }
                        mappedField.mt.problem = "Manually added field";
                        mappedField.optional = false;
                        if (mt.typeFields == null) {
                            mt.typeFields = new ArrayList<TSMappedType.MappedField>();
                        }
                        mt.typeFields.add(mappedField);
                    }
                }
                if (clazz.isEnum()) {
                    mt.enumValues = Arrays.stream(clazz.getEnumConstants()).map(enumConstant -> {
                        try {
                            TSMappedType.MappedEnumValue enumValue = new TSMappedType.MappedEnumValue();
                            String enumName = ((Enum)enumConstant).name();
                            SerializedName serializedName = clazz.getField(enumName).getAnnotation(SerializedName.class);
                            enumValue.name = serializedName == null ? enumName : serializedName.value();
                            enumValue.value = enumConstant.toString();
                            return enumValue;
                        }
                        catch (NoSuchFieldException e) {
                            throw new RuntimeException(e);
                        }
                    }).collect(Collectors.toList());
                    return;
                }
                mt.tsType = TSMappedType.TSType.INTERFACE;
                mt.typeParameters = Arrays.stream(clazz.getTypeParameters()).map(ExceptionUtils.checkedFunction(this::mapType)).collect(Collectors.toList());
                mt.concrete = !Modifier.isAbstract(clazz.getModifiers());
                Class superclass = clazz.getSuperclass();
                if (superclass != null && !superclass.equals(Object.class)) {
                    mt.rawSuperclass = this.mapType(superclass);
                }
                mt.superclass = (sc = clazz.getGenericSuperclass()) != null ? this.mapType(sc) : mt.rawSuperclass;
                if (clazz.getGenericSuperclass() instanceof ParameterizedType) {
                    Type[] typeArray;
                    ParameterizedType parameterizedType = (ParameterizedType)clazz.getGenericSuperclass();
                    for (Type type : typeArray = parameterizedType.getActualTypeArguments()) {
                        this.mapType(type);
                    }
                }
                mt.hasJavaSubclasses = this.classScanner.hasSubclasses(clazz);
                if (mt.polyJsonMeta != null) {
                    mt.hasPolyJsonAnnotation = mt.polyJsonMeta.getAnnotatedClass() == clazz;
                    mt.polyJsonType = mt.polyJsonMeta.getTypeFromClass(clazz);
                    mt.polyJsonSubclasses = mt.polyJsonMeta.listSubClasses().stream().filter(clazz::isAssignableFrom).sorted(Comparator.comparing(Class::getName)).map(ExceptionUtils.checkedFunction(this::mapType)).collect(Collectors.toList());
                    this.exploreAndGenerateUnionOfSubclasses(mt);
                }
            }
        } else if (mt.javaType instanceof ParameterizedType) {
            Type raw = ((ParameterizedType)mt.javaType).getRawType();
            if (raw instanceof Class) {
                Class rawClass = (Class)raw;
                if (Map.class.isAssignableFrom(rawClass)) {
                    mt.tsType = TSMappedType.TSType.MAP;
                    mt.typeParameters = Arrays.stream(.Gson.Types.getMapKeyAndValueTypes((Type)mt.javaType, (Class)rawClass)).map(ExceptionUtils.checkedFunction(this::mapType)).collect(Collectors.toList());
                    TSMappedType keyType = mt.typeParameters.get(0);
                    if (keyType.tsType != TSMappedType.TSType.STRING && keyType.tsType != TSMappedType.TSType.ENUM && keyType.tsType != TSMappedType.TSType.NUMBER && keyType.tsType != TSMappedType.TSType.ANY) {
                        mt.typeParameters.set(0, this.mapType((Type)((Object)String.class)));
                        mt.logTranslationIssue("Invalid map key (must be string or enum)");
                    }
                } else if (Collection.class.isAssignableFrom(rawClass)) {
                    mt.tsType = TSMappedType.TSType.LIST;
                    mt.typeParameters = Lists.newArrayList((Object[])new TSMappedType[]{this.mapType(.Gson.Types.getCollectionElementType((Type)mt.javaType, (Class)rawClass))});
                } else if (rawClass.isArray()) {
                    mt.tsType = TSMappedType.TSType.LIST;
                    mt.typeParameters = Lists.newArrayList((Object[])new TSMappedType[]{this.mapType(.Gson.Types.getArrayComponentType((Type)mt.javaType))});
                }
            }
            if (mt.tsType == null) {
                mt.tsType = TSMappedType.TSType.PARAMETRIZED_TYPE;
                mt.typeParameters = Arrays.stream(((ParameterizedType)mt.javaType).getActualTypeArguments()).map(ExceptionUtils.checkedFunction(this::mapType)).collect(Collectors.toList());
                mt.rawJavaType = this.mapType(raw);
            }
        } else if (mt.javaType instanceof TypeVariable) {
            mt.tsType = TSMappedType.TSType.TYPE_VARIABLE;
            mt.tsName = ((TypeVariable)mt.javaType).getName();
        } else if (mt.javaType instanceof GenericArrayType) {
            mt.tsType = TSMappedType.TSType.LIST;
            mt.typeParameters = Lists.newArrayList((Object[])new TSMappedType[]{this.mapType(.Gson.Types.getArrayComponentType((Type)mt.javaType))});
        }
        if (mt.tsType == null) {
            mt.tsType = TSMappedType.TSType.UNKNOWN;
            mt.problem = "No mapping for " + String.valueOf(mt.javaType);
            mt.logTranslationIssue("No mapping");
        }
    }

    public void mapTypeAndGenerateUnion(Type type) throws Exception {
        this.exploreAndGenerateUnionOfSubclasses(this.mapType(type));
    }

    private void exploreAndGenerateUnionOfSubclasses(TSMappedType mt) throws Exception {
        if (!mt.generateUnion && mt.tsType == TSMappedType.TSType.INTERFACE) {
            mt.generateUnion = true;
            for (Class<?> subclass : this.classScanner.listSubclasses((Class)mt.javaType)) {
                TSMappedType subMt2 = this.mapType(subclass);
                if (subMt2.tsType == TSMappedType.TSType.INTERFACE) {
                    mt.subclasses.add(subMt2);
                }
                if (!((Class)mt.javaType).isInterface()) continue;
                subMt2.implementedInterfaces.add(mt);
            }
            if (mt.foreignMapping != null) {
                TSMappedType.PersistedTypeMeta meta = mt.foreignMapping.javaToTs.get(mt.javaType.getTypeName());
                List subclassesNotKnownInForeignMapping = mt.subclasses.stream().filter(subMt -> !meta.concreteSubclasses.contains(subMt.javaType.getTypeName())).collect(Collectors.toList());
                if (!subclassesNotKnownInForeignMapping.isEmpty()) {
                    mt.logTranslationIssue(subclassesNotKnownInForeignMapping.size() + " subclass(es) missing in union type");
                }
            }
        }
    }

    private TSMappedType mapType(Type type) throws Exception {
        TSMappedType mt;
        Preconditions.checkNotNull((Object)type);
        if (type instanceof WildcardType) {
            Type[] upper = ((WildcardType)type).getUpperBounds();
            type = upper.length > 0 ? upper[0] : JsonElement.class;
        }
        if ((mt = this.localMappings.get(type)) == null) {
            mt = new TSMappedType();
            mt.translatedVia = this.currentTranslatedVia;
            mt.translatedViaDepth = this.currentTranslatedViaDepth++;
            mt.javaType = type;
            this.localMappings.put((Type)type, mt);
            TSMappedType previousTranslatedVia = this.currentTranslatedVia;
            this.currentTranslatedVia = mt;
            this.inspectType(mt);
            --this.currentTranslatedViaDepth;
            this.currentTranslatedVia = previousTranslatedVia;
        }
        if (this.currentTranslatedViaDepth < mt.translatedViaDepth) {
            mt.translatedVia = this.currentTranslatedVia;
            mt.translatedViaDepth = this.currentTranslatedViaDepth;
        }
        return mt;
    }
}

