/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.logging;

import com.dataiku.dip.utils.DKULogger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;

public class LimitedLogContext
implements AutoCloseable {
    private volatile DKULogger logger;
    public final Level level;
    protected final AtomicLong count = new AtomicLong();
    public final long limit;

    LimitedLogContext(DKULogger logger, long limit) {
        this(logger, limit, Level.DEBUG);
    }

    LimitedLogContext(DKULogger logger, long limit, Level level) {
        this.logger = logger;
        this.limit = limit;
        this.level = level;
    }

    public boolean isEnabled() {
        return this.logger != null && this.logger.isEnabledFor((Priority)this.level);
    }

    public void log(String message) {
        if (!this.isEnabled()) {
            return;
        }
        if (this.count.incrementAndGet() <= this.limit) {
            this.logger.log((Priority)this.level, message);
        }
    }

    public void log(String message, Throwable t) {
        if (!this.isEnabled()) {
            return;
        }
        if (this.count.incrementAndGet() <= this.limit) {
            this.logger.log((Priority)this.level, message, t);
        }
    }

    public void logV(String message, Object ... format) {
        this.log(String.format(message, format));
    }

    public long getCount() {
        return this.count.get();
    }

    @Override
    public synchronized void close() {
        if (this.logger != null) {
            if (this.getCount() > this.limit) {
                this.logger.log((Priority)this.level, this.getCount() + " log messages, clipped after " + this.limit);
            }
            this.logger = null;
        }
    }
}

