/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.core.http.netty.implementation;

import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpHeaderName;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpRequest;
import com.dataiku.dss.shadelibazure.com.azure.core.http.netty.implementation.ByteBufWriteSubscriber;
import com.dataiku.dss.shadelibazure.com.azure.core.http.netty.implementation.NettyAsyncHttpResponseBase;
import com.dataiku.dss.shadelibazure.com.azure.core.http.netty.implementation.NettyUtility;
import com.dataiku.dss.shadelibazure.com.azure.core.util.CoreUtils;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Flux;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.MonoSink;
import com.dataiku.dss.shadelibazure.reactor.core.scheduler.Schedulers;
import com.dataiku.dss.shadelibazure.reactor.netty.ByteBufFlux;
import com.dataiku.dss.shadelibazure.reactor.netty.Connection;
import com.dataiku.dss.shadelibazure.reactor.netty.http.client.HttpClientResponse;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.Charset;

public final class NettyAsyncHttpResponse
extends NettyAsyncHttpResponseBase {
    private final Connection reactorNettyConnection;
    private final boolean disableBufferCopy;

    public NettyAsyncHttpResponse(HttpClientResponse reactorNettyResponse, Connection reactorNettyConnection, HttpRequest httpRequest, boolean disableBufferCopy, boolean headersEagerlyConverted) {
        super(reactorNettyResponse, httpRequest, headersEagerlyConverted);
        this.reactorNettyConnection = reactorNettyConnection;
        this.disableBufferCopy = disableBufferCopy;
    }

    @Override
    public Flux<ByteBuffer> getBody() {
        return Flux.using(() -> this, response -> response.bodyIntern().map(byteBuf -> this.disableBufferCopy ? byteBuf.nioBuffer() : NettyUtility.deepCopyBuffer(byteBuf)), NettyAsyncHttpResponse::close);
    }

    @Override
    public Mono<byte[]> getBodyAsByteArray() {
        return Mono.using(() -> this, response -> response.bodyIntern().aggregate().asByteArray(), NettyAsyncHttpResponse::close);
    }

    @Override
    public Mono<String> getBodyAsString() {
        return this.getBodyAsByteArray().map(bytes -> CoreUtils.bomAwareToString(bytes, this.getHeaderValue(HttpHeaderName.CONTENT_TYPE)));
    }

    @Override
    public Mono<String> getBodyAsString(Charset charset) {
        return Mono.using(() -> this, response -> response.bodyIntern().aggregate().asString(charset), NettyAsyncHttpResponse::close);
    }

    @Override
    public Mono<InputStream> getBodyAsInputStream() {
        return Mono.using(() -> this, response -> response.bodyIntern().aggregate().asInputStream(), NettyAsyncHttpResponse::close);
    }

    @Override
    public Mono<Void> writeBodyToAsync(AsynchronousByteChannel channel) {
        Long length = this.getContentLength();
        return Mono.using(() -> this, response -> Mono.create(sink2 -> response.bodyIntern().subscribe(new ByteBufWriteSubscriber(byteBuffer -> channel.write((ByteBuffer)byteBuffer).get(), (MonoSink<Void>)sink2, length))), NettyAsyncHttpResponse::close);
    }

    @Override
    public void writeBodyTo(WritableByteChannel channel) {
        Mono.using(() -> this, response -> Mono.create(sink2 -> response.bodyIntern().subscribe(new ByteBufWriteSubscriber(channel::write, (MonoSink<Void>)sink2, this.getContentLength()))).subscribeOn(Schedulers.boundedElastic()), NettyAsyncHttpResponse::close).block();
    }

    @Override
    public void close() {
        NettyUtility.closeConnection(this.reactorNettyConnection);
    }

    private ByteBufFlux bodyIntern() {
        return this.reactorNettyConnection.inbound().receive();
    }

    public Connection internConnection() {
        return this.reactorNettyConnection;
    }

    private Long getContentLength() {
        String contentLength = this.getHeaders().getValue(HttpHeaderName.CONTENT_LENGTH);
        if (contentLength == null) {
            return null;
        }
        try {
            return Long.parseLong(contentLength);
        }
        catch (NumberFormatException ex) {
            return null;
        }
    }
}

