/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.core.http.okhttp.implementation;

import com.dataiku.dss.shadelibazure.com.azure.core.implementation.util.BinaryDataContent;
import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.okhttp3.MediaType;
import com.dataiku.dss.shadelibazure.okhttp3.RequestBody;
import com.dataiku.dss.shadelibazure.okio.BufferedSink;
import com.dataiku.dss.shadelibazure.reactor.core.Exceptions;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import com.dataiku.dss.shadelibazure.reactor.core.scheduler.Schedulers;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;

public class OkHttpFluxRequestBody
extends RequestBody {
    private static final ClientLogger LOGGER = new ClientLogger(OkHttpFluxRequestBody.class);
    private final BinaryDataContent content;
    private final long effectiveContentLength;
    private final MediaType mediaType;
    private final AtomicBoolean bodySent = new AtomicBoolean(false);
    private final int callTimeoutMillis;

    @Override
    public boolean isOneShot() {
        return true;
    }

    @Override
    public final MediaType contentType() {
        return this.mediaType;
    }

    @Override
    public final long contentLength() {
        return this.effectiveContentLength;
    }

    public OkHttpFluxRequestBody(BinaryDataContent content, long effectiveContentLength, MediaType mediaType, int callTimeoutMillis) {
        this.content = Objects.requireNonNull(content, "'content' cannot be null.");
        this.effectiveContentLength = effectiveContentLength;
        this.mediaType = mediaType;
        this.callTimeoutMillis = callTimeoutMillis;
    }

    @Override
    public void writeTo(BufferedSink bufferedSink) throws IOException {
        if (this.bodySent.compareAndSet(false, true)) {
            Mono<Void> requestSendMono = this.content.toFluxByteBuffer().flatMapSequential(buffer -> {
                if (Schedulers.isInNonBlockingThread()) {
                    return Mono.just(buffer).publishOn(Schedulers.boundedElastic()).map(b -> OkHttpFluxRequestBody.writeBuffer(bufferedSink, b)).then();
                }
                OkHttpFluxRequestBody.writeBuffer(bufferedSink, buffer);
                return Mono.empty();
            }, 1, 1).then();
            if (this.callTimeoutMillis > 0) {
                requestSendMono.block(Duration.ofMillis(this.callTimeoutMillis));
            } else {
                requestSendMono.block();
            }
        } else {
            throw LOGGER.logThrowableAsError(new IOException("Re-attempt to send Flux body is not supported"));
        }
    }

    private static ByteBuffer writeBuffer(BufferedSink sink2, ByteBuffer buffer) {
        try {
            while (buffer.hasRemaining()) {
                sink2.write(buffer);
            }
            return buffer;
        }
        catch (IOException e) {
            throw Exceptions.propagate(e);
        }
    }
}

