/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.core.http.okhttp.implementation;

import com.dataiku.dss.shadelibazure.com.azure.core.util.SharedExecutorService;
import com.dataiku.dss.shadelibazure.okhttp3.Call;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

public final class PerCallTimeoutCall {
    private final long perCallTimeout;
    private volatile boolean timedOut;
    private static final AtomicReferenceFieldUpdater<PerCallTimeoutCall, ScheduledFuture> CURRENT_TIMEOUT_UPDATER = AtomicReferenceFieldUpdater.newUpdater(PerCallTimeoutCall.class, ScheduledFuture.class, "currentTimeout");
    private volatile ScheduledFuture currentTimeout;

    public PerCallTimeoutCall(long perCallTimeout) {
        this.perCallTimeout = perCallTimeout;
    }

    public void beginPerCallTimeout(Call call) {
        ScheduledFuture<?> future;
        ScheduledFuture<?> existing;
        if (this.perCallTimeout > 0L && (existing = CURRENT_TIMEOUT_UPDATER.getAndSet(this, future = SharedExecutorService.getInstance().schedule(() -> {
            this.timedOut = true;
            call.cancel();
        }, this.perCallTimeout, TimeUnit.MILLISECONDS))) != null) {
            existing.cancel(false);
        }
    }

    public void endPerCallTimeout() {
        ScheduledFuture currentTimeout = CURRENT_TIMEOUT_UPDATER.getAndSet(this, null);
        if (currentTimeout != null) {
            currentTimeout.cancel(false);
        }
    }

    public boolean isTimedOut() {
        return this.timedOut;
    }
}

