/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.core.http.policy;

import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpHeaderName;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpHeaders;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpPipelineCallContext;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpPipelineNextPolicy;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpPipelineNextSyncPolicy;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpRequest;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpResponse;
import com.dataiku.dss.shadelibazure.com.azure.core.http.policy.ExponentialBackoff;
import com.dataiku.dss.shadelibazure.com.azure.core.http.policy.HttpPipelinePolicy;
import com.dataiku.dss.shadelibazure.com.azure.core.http.policy.RequestRetryCondition;
import com.dataiku.dss.shadelibazure.com.azure.core.http.policy.RetryOptions;
import com.dataiku.dss.shadelibazure.com.azure.core.http.policy.RetryStrategy;
import com.dataiku.dss.shadelibazure.com.azure.core.implementation.ImplUtils;
import com.dataiku.dss.shadelibazure.com.azure.core.util.BinaryData;
import com.dataiku.dss.shadelibazure.com.azure.core.util.CoreUtils;
import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.LoggingEventBuilder;
import com.dataiku.dss.shadelibazure.reactor.core.Exceptions;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.time.temporal.ChronoUnit;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;

public class RetryPolicy
implements HttpPipelinePolicy {
    private static final ClientLogger LOGGER = new ClientLogger(RetryPolicy.class);
    private final RetryStrategy retryStrategy;
    private final HttpHeaderName retryAfterHeader;
    private final ChronoUnit retryAfterTimeUnit;

    public RetryPolicy() {
        this(new ExponentialBackoff(), null, null);
    }

    public RetryPolicy(String retryAfterHeader, ChronoUnit retryAfterTimeUnit) {
        this(new ExponentialBackoff(), retryAfterHeader, retryAfterTimeUnit);
    }

    public RetryPolicy(RetryStrategy retryStrategy, String retryAfterHeader, ChronoUnit retryAfterTimeUnit) {
        this.retryStrategy = Objects.requireNonNull(retryStrategy, "'retryStrategy' cannot be null.");
        this.retryAfterHeader = HttpHeaderName.fromString(retryAfterHeader);
        this.retryAfterTimeUnit = retryAfterTimeUnit;
        if (!CoreUtils.isNullOrEmpty(retryAfterHeader)) {
            Objects.requireNonNull(retryAfterTimeUnit, "'retryAfterTimeUnit' cannot be null.");
        }
    }

    public RetryPolicy(RetryStrategy retryStrategy) {
        this(retryStrategy, null, null);
    }

    public RetryPolicy(RetryOptions retryOptions) {
        this(ImplUtils.getRetryStrategyFromOptions(retryOptions), null, null);
    }

    @Override
    public Mono<HttpResponse> process(HttpPipelineCallContext context, HttpPipelineNextPolicy next) {
        HttpRequest originalHttpRequest = context.getHttpRequest();
        BinaryData originalRequestBody = originalHttpRequest.getBodyAsBinaryData();
        if (this.retryStrategy.getMaxRetries() > 0 && originalRequestBody != null && !originalRequestBody.isReplayable()) {
            return originalRequestBody.toReplayableBinaryDataAsync().flatMap(replayableBody -> {
                context.getHttpRequest().setBody((BinaryData)replayableBody);
                return this.attemptAsync(context, next, originalHttpRequest, 0, null);
            });
        }
        return this.attemptAsync(context, next, originalHttpRequest, 0, null);
    }

    @Override
    public HttpResponse processSync(HttpPipelineCallContext context, HttpPipelineNextSyncPolicy next) {
        HttpRequest originalHttpRequest = context.getHttpRequest();
        BinaryData originalRequestBody = originalHttpRequest.getBodyAsBinaryData();
        if (this.retryStrategy.getMaxRetries() > 0 && originalRequestBody != null && !originalRequestBody.isReplayable()) {
            context.getHttpRequest().setBody(context.getHttpRequest().getBodyAsBinaryData().toReplayableBinaryData());
        }
        return this.attemptSync(context, next, originalHttpRequest, 0, null);
    }

    private Mono<HttpResponse> attemptAsync(HttpPipelineCallContext context, HttpPipelineNextPolicy next, HttpRequest originalHttpRequest, int tryCount, List<Throwable> suppressed) {
        context.setData("requestRetryCount", tryCount + 1);
        context.setHttpRequest(originalHttpRequest.copy());
        return next.clone().process().flatMap(httpResponse -> {
            if (RetryPolicy.shouldRetry(this.retryStrategy, httpResponse, tryCount, suppressed)) {
                Duration delayDuration = RetryPolicy.determineDelayDuration(httpResponse, tryCount, this.retryStrategy, this.retryAfterHeader, this.retryAfterTimeUnit);
                RetryPolicy.logRetry(tryCount, delayDuration);
                httpResponse.close();
                return this.addBackoffDelay(this.attemptAsync(context, next, originalHttpRequest, tryCount + 1, suppressed), delayDuration);
            }
            if (tryCount >= this.retryStrategy.getMaxRetries()) {
                RetryPolicy.logRetryExhausted(tryCount);
            }
            return Mono.just(httpResponse);
        }).onErrorResume(Exception.class, err -> {
            if (RetryPolicy.shouldRetryException(this.retryStrategy, err, tryCount, suppressed)) {
                RetryPolicy.logRetryWithError(LOGGER.atVerbose(), tryCount, "Error resume.", err);
                List suppressedLocal = suppressed == null ? new LinkedList() : suppressed;
                suppressedLocal.add(err);
                return this.addBackoffDelay(this.attemptAsync(context, next, originalHttpRequest, tryCount + 1, suppressedLocal), this.retryStrategy.calculateRetryDelay(tryCount));
            }
            RetryPolicy.logRetryWithError(LOGGER.atError(), tryCount, "Retry attempts have been exhausted.", err);
            if (suppressed != null) {
                suppressed.forEach(err::addSuppressed);
            }
            return Mono.error(err);
        });
    }

    private Mono<HttpResponse> addBackoffDelay(Mono<HttpResponse> retryOperation, Duration delayDuration) {
        return !delayDuration.isNegative() && !delayDuration.isZero() ? retryOperation.delaySubscription(delayDuration) : retryOperation;
    }

    private HttpResponse attemptSync(HttpPipelineCallContext context, HttpPipelineNextSyncPolicy next, HttpRequest originalHttpRequest, int tryCount, List<Throwable> suppressed) {
        HttpResponse httpResponse;
        try {
            context.setData("requestRetryCount", tryCount + 1);
            context.setHttpRequest(originalHttpRequest.copy());
            httpResponse = next.clone().processSync();
        }
        catch (RuntimeException err) {
            if (RetryPolicy.shouldRetryException(this.retryStrategy, err, tryCount, suppressed)) {
                RetryPolicy.logRetryWithError(LOGGER.atVerbose(), tryCount, "Error resume.", err);
                Duration delayDuration = this.retryStrategy.calculateRetryDelay(tryCount);
                if (!delayDuration.isNegative() && !delayDuration.isZero()) {
                    try {
                        Thread.sleep(delayDuration.toMillis());
                    }
                    catch (InterruptedException ex) {
                        err.addSuppressed(ex);
                        throw LOGGER.logExceptionAsError(err);
                    }
                }
                LinkedList<Throwable> suppressedLocal = suppressed == null ? new LinkedList<Throwable>() : suppressed;
                suppressedLocal.add(err);
                return this.attemptSync(context, next, originalHttpRequest, tryCount + 1, suppressedLocal);
            }
            RetryPolicy.logRetryWithError(LOGGER.atError(), tryCount, "Retry attempts have been exhausted.", err);
            if (suppressed != null) {
                suppressed.forEach(err::addSuppressed);
            }
            throw LOGGER.logExceptionAsError(err);
        }
        if (RetryPolicy.shouldRetry(this.retryStrategy, httpResponse, tryCount, suppressed)) {
            Duration delayDuration = RetryPolicy.determineDelayDuration(httpResponse, tryCount, this.retryStrategy, this.retryAfterHeader, this.retryAfterTimeUnit);
            RetryPolicy.logRetry(tryCount, delayDuration);
            httpResponse.close();
            if (!delayDuration.isNegative() && !delayDuration.isZero()) {
                try {
                    Thread.sleep(delayDuration.toMillis());
                }
                catch (InterruptedException ie) {
                    throw LOGGER.logExceptionAsError(new RuntimeException(ie));
                }
            }
            return this.attemptSync(context, next, originalHttpRequest, tryCount + 1, suppressed);
        }
        if (tryCount >= this.retryStrategy.getMaxRetries()) {
            RetryPolicy.logRetryExhausted(tryCount);
        }
        return httpResponse;
    }

    private static boolean shouldRetry(RetryStrategy retryStrategy, HttpResponse response, int tryCount, List<Throwable> retriedExceptions) {
        return tryCount < retryStrategy.getMaxRetries() && retryStrategy.shouldRetryCondition(new RequestRetryCondition(response, null, tryCount, retriedExceptions));
    }

    private static boolean shouldRetryException(RetryStrategy retryStrategy, Throwable throwable, int tryCount, List<Throwable> retriedExceptions) {
        Throwable causalThrowable;
        if (tryCount >= retryStrategy.getMaxRetries()) {
            return false;
        }
        RequestRetryCondition requestRetryCondition = new RequestRetryCondition(null, causalThrowable, tryCount, retriedExceptions);
        for (causalThrowable = Exceptions.unwrap(throwable); causalThrowable != null; causalThrowable = causalThrowable.getCause()) {
            if (retryStrategy.shouldRetryCondition(requestRetryCondition)) {
                return true;
            }
            requestRetryCondition = new RequestRetryCondition(null, causalThrowable, tryCount, retriedExceptions);
        }
        return false;
    }

    private static void logRetry(int tryCount, Duration delayDuration) {
        LOGGER.atVerbose().addKeyValue("tryCount", tryCount).addKeyValue("durationMs", delayDuration.toMillis()).log("Retrying.");
    }

    private static void logRetryExhausted(int tryCount) {
        LOGGER.atInfo().addKeyValue("tryCount", tryCount).log("Retry attempts have been exhausted.");
    }

    private static void logRetryWithError(LoggingEventBuilder loggingEventBuilder, int tryCount, String format, Throwable throwable) {
        loggingEventBuilder.addKeyValue("tryCount", tryCount).log(format, throwable);
    }

    static Duration determineDelayDuration(HttpResponse response, int tryCount, RetryStrategy retryStrategy, HttpHeaderName retryAfterHeader, ChronoUnit retryAfterTimeUnit) {
        if (retryAfterHeader == null) {
            return RetryPolicy.getWellKnownRetryDelay(response.getHeaders(), tryCount, retryStrategy, OffsetDateTime::now);
        }
        String retryHeaderValue = response.getHeaderValue(retryAfterHeader);
        if (CoreUtils.isNullOrEmpty(retryHeaderValue)) {
            return retryStrategy.calculateRetryDelay(tryCount);
        }
        return Duration.of(Integer.parseInt(retryHeaderValue), retryAfterTimeUnit);
    }

    static Duration getWellKnownRetryDelay(HttpHeaders responseHeaders, int tryCount, RetryStrategy retryStrategy, Supplier<OffsetDateTime> nowSupplier) {
        Duration retryDelay = ImplUtils.getRetryAfterFromHeaders(responseHeaders, nowSupplier);
        if (retryDelay != null) {
            return retryDelay;
        }
        return retryStrategy.calculateRetryDelay(tryCount);
    }
}

