/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.core.implementation;

import java.security.AccessController;
import java.util.concurrent.Callable;
import java.util.function.Supplier;

public final class AccessControllerUtils {
    private static final boolean CAN_BE_USED;

    public static <T> T doPrivileged(Supplier<T> privilegedAction) {
        if (!CAN_BE_USED) {
            return privilegedAction.get();
        }
        return (T)AccessController.doPrivileged(privilegedAction::get);
    }

    public static <T> T doPrivilegedException(Callable<T> privilegedActionException) throws Exception {
        if (!CAN_BE_USED) {
            return privilegedActionException.call();
        }
        return (T)AccessController.doPrivileged(privilegedActionException::call);
    }

    private AccessControllerUtils() {
    }

    static {
        ClassLoader classLoader = AccessControllerUtils.class.getClassLoader();
        boolean canBeUsed = false;
        try {
            Class.forName("java.security.AccessController", true, classLoader);
            Class.forName("java.security.PrivilegedAction", true, classLoader);
            Class.forName("java.security.PrivilegedExceptionAction", true, classLoader);
            canBeUsed = true;
        }
        catch (LinkageError | ReflectiveOperationException throwable) {
            // empty catch block
        }
        CAN_BE_USED = canBeUsed;
    }
}

