/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.core.implementation.http.rest;

import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ResumeOperation;
import com.dataiku.dss.shadelibazure.com.azure.core.exception.UnexpectedLengthException;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpHeaderName;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpPipeline;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpPipelineBuilder;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpRequest;
import com.dataiku.dss.shadelibazure.com.azure.core.http.policy.CookiePolicy;
import com.dataiku.dss.shadelibazure.com.azure.core.http.policy.HttpPipelinePolicy;
import com.dataiku.dss.shadelibazure.com.azure.core.http.policy.RetryPolicy;
import com.dataiku.dss.shadelibazure.com.azure.core.http.policy.UserAgentPolicy;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.RequestOptions;
import com.dataiku.dss.shadelibazure.com.azure.core.implementation.http.rest.LengthValidatingInputStream;
import com.dataiku.dss.shadelibazure.com.azure.core.implementation.util.BinaryDataContent;
import com.dataiku.dss.shadelibazure.com.azure.core.implementation.util.BinaryDataHelper;
import com.dataiku.dss.shadelibazure.com.azure.core.implementation.util.FluxByteBufferContent;
import com.dataiku.dss.shadelibazure.com.azure.core.implementation.util.InputStreamContent;
import com.dataiku.dss.shadelibazure.com.azure.core.util.BinaryData;
import com.dataiku.dss.shadelibazure.com.azure.core.util.Context;
import com.dataiku.dss.shadelibazure.com.azure.core.util.CoreUtils;
import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.core.util.serializer.JacksonAdapter;
import com.dataiku.dss.shadelibazure.com.azure.core.util.serializer.SerializerAdapter;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Flux;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.ArrayList;

public final class RestProxyUtils {
    private static final ByteBuffer VALIDATION_BUFFER = ByteBuffer.allocate(0);
    public static final String BODY_TOO_LARGE = "Request body emitted %d bytes, more than the expected %d bytes.";
    public static final String BODY_TOO_SMALL = "Request body emitted %d bytes, less than the expected %d bytes.";
    public static final ClientLogger LOGGER = new ClientLogger(RestProxyUtils.class);

    private RestProxyUtils() {
    }

    public static Mono<HttpRequest> validateLengthAsync(HttpRequest request) {
        BinaryData body = request.getBodyAsBinaryData();
        if (body == null) {
            return Mono.just(request);
        }
        return Mono.fromCallable(() -> {
            BinaryDataContent content = BinaryDataHelper.getContent(body);
            long expectedLength = Long.parseLong(request.getHeaders().getValue(HttpHeaderName.CONTENT_LENGTH));
            if (content instanceof InputStreamContent) {
                LengthValidatingInputStream validatingInputStream = new LengthValidatingInputStream(content.toStream(), expectedLength);
                request.setBody(BinaryData.fromStream(validatingInputStream, expectedLength));
            } else if (content instanceof FluxByteBufferContent) {
                request.setBody(RestProxyUtils.validateFluxLength(body.toFluxByteBuffer(), expectedLength));
            } else {
                Long bodyLength = body.getLength();
                if (bodyLength != null) {
                    if (bodyLength < expectedLength) {
                        throw new UnexpectedLengthException(String.format(BODY_TOO_SMALL, bodyLength, expectedLength), bodyLength, expectedLength);
                    }
                    if (bodyLength > expectedLength) {
                        throw new UnexpectedLengthException(String.format(BODY_TOO_LARGE, bodyLength, expectedLength), bodyLength, expectedLength);
                    }
                } else {
                    request.setBody(RestProxyUtils.validateFluxLength(body.toFluxByteBuffer(), expectedLength));
                }
            }
            return request;
        });
    }

    private static Flux<ByteBuffer> validateFluxLength(Flux<ByteBuffer> bbFlux, long expectedLength) {
        if (bbFlux == null) {
            return Flux.empty();
        }
        return Flux.defer(() -> {
            long[] currentTotalLength = new long[1];
            return Flux.concat(bbFlux, Flux.just(VALIDATION_BUFFER)).handle((buffer, sink2) -> {
                if (buffer == null) {
                    return;
                }
                if (buffer == VALIDATION_BUFFER) {
                    if (expectedLength != currentTotalLength[0]) {
                        sink2.error(new UnexpectedLengthException(String.format(BODY_TOO_SMALL, currentTotalLength[0], expectedLength), currentTotalLength[0], expectedLength));
                    } else {
                        sink2.complete();
                    }
                    return;
                }
                currentTotalLength[0] = currentTotalLength[0] + (long)buffer.remaining();
                if (currentTotalLength[0] > expectedLength) {
                    sink2.error(new UnexpectedLengthException(String.format(BODY_TOO_LARGE, currentTotalLength[0], expectedLength), currentTotalLength[0], expectedLength));
                    return;
                }
                sink2.next(buffer);
            });
        });
    }

    public static BinaryData validateLengthSync(HttpRequest request) {
        BinaryData binaryData = request.getBodyAsBinaryData();
        if (binaryData == null) {
            return null;
        }
        long expectedLength = Long.parseLong(request.getHeaders().getValue(HttpHeaderName.CONTENT_LENGTH));
        Long length = binaryData.getLength();
        BinaryDataContent bdc = BinaryDataHelper.getContent(binaryData);
        if (bdc instanceof FluxByteBufferContent) {
            throw new IllegalStateException("Flux Byte Buffer is not supported in Synchronous Rest Proxy.");
        }
        if (bdc instanceof InputStreamContent) {
            InputStreamContent inputStreamContent = (InputStreamContent)bdc;
            InputStream inputStream2 = inputStreamContent.toStream();
            LengthValidatingInputStream lengthValidatingInputStream = new LengthValidatingInputStream(inputStream2, expectedLength);
            return BinaryData.fromStream(lengthValidatingInputStream, expectedLength);
        }
        if (length == null) {
            byte[] b = bdc.toBytes();
            length = Integer.valueOf(b.length).longValue();
            RestProxyUtils.validateLength(length, expectedLength);
            return BinaryData.fromBytes(b);
        }
        RestProxyUtils.validateLength(length, expectedLength);
        return binaryData;
    }

    private static void validateLength(long length, long expectedLength) {
        if (length > expectedLength) {
            throw new UnexpectedLengthException(String.format(BODY_TOO_LARGE, length, expectedLength), length, expectedLength);
        }
        if (length < expectedLength) {
            throw new UnexpectedLengthException(String.format(BODY_TOO_SMALL, length, expectedLength), length, expectedLength);
        }
    }

    public static Context mergeRequestOptionsContext(Context context, RequestOptions options) {
        if (options == null) {
            return context;
        }
        Context optionsContext = options.getContext();
        if (optionsContext != null && optionsContext != Context.NONE) {
            context = CoreUtils.mergeContexts(context, optionsContext);
        }
        return context;
    }

    public static void validateResumeOperationIsNotPresent(Method method) {
        if (method.isAnnotationPresent(ResumeOperation.class)) {
            throw LOGGER.logExceptionAsError(new IllegalStateException("'ResumeOperation' isn't supported."));
        }
    }

    public static SerializerAdapter createDefaultSerializer() {
        return JacksonAdapter.createDefaultSerializerAdapter();
    }

    public static HttpPipeline createDefaultPipeline() {
        ArrayList<HttpPipelinePolicy> policies = new ArrayList<HttpPipelinePolicy>();
        policies.add(new UserAgentPolicy());
        policies.add(new RetryPolicy());
        policies.add(new CookiePolicy());
        return new HttpPipelineBuilder().policies(policies.toArray(new HttpPipelinePolicy[0])).build();
    }
}

