/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.core.implementation.jackson;

import com.dataiku.dss.shadelibazure.com.azure.core.implementation.ReflectionSerializable;
import com.dataiku.dss.shadelibazure.com.azure.core.implementation.ReflectionUtils;
import com.dataiku.dss.shadelibazure.com.azure.core.implementation.ReflectiveInvoker;
import com.dataiku.dss.shadelibazure.com.azure.core.implementation.jackson.AzureJsonUtils;
import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.fasterxml.jackson.core.JsonParser;
import com.dataiku.dss.shadelibazure.com.fasterxml.jackson.databind.BeanDescription;
import com.dataiku.dss.shadelibazure.com.fasterxml.jackson.databind.DeserializationConfig;
import com.dataiku.dss.shadelibazure.com.fasterxml.jackson.databind.DeserializationContext;
import com.dataiku.dss.shadelibazure.com.fasterxml.jackson.databind.JsonDeserializer;
import com.dataiku.dss.shadelibazure.com.fasterxml.jackson.databind.Module;
import com.dataiku.dss.shadelibazure.com.fasterxml.jackson.databind.deser.BeanDeserializerModifier;
import com.dataiku.dss.shadelibazure.com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.IOException;

final class JsonSerializableDeserializer
extends JsonDeserializer<JsonSerializable<?>> {
    private static final ClientLogger LOGGER = new ClientLogger(JsonSerializableDeserializer.class);
    private final Class<? extends JsonSerializable<?>> jsonSerializableType;
    private final ReflectiveInvoker readJson;

    public static Module getModule() {
        return new SimpleModule().setDeserializerModifier(new BeanDeserializerModifier(){

            @Override
            public JsonDeserializer<?> modifyDeserializer(DeserializationConfig config, BeanDescription beanDesc, JsonDeserializer<?> deserializer) {
                return ReflectionSerializable.supportsJsonSerializable(beanDesc.getBeanClass()) ? new JsonSerializableDeserializer(beanDesc.getBeanClass()) : deserializer;
            }
        });
    }

    JsonSerializableDeserializer(Class<? extends JsonSerializable<?>> jsonSerializableType) {
        this.jsonSerializableType = jsonSerializableType;
        try {
            this.readJson = ReflectionUtils.getMethodInvoker(jsonSerializableType, jsonSerializableType.getDeclaredMethod("fromJson", JsonReader.class));
        }
        catch (Exception e) {
            throw LOGGER.logExceptionAsError(new IllegalStateException(e));
        }
    }

    @Override
    public JsonSerializable<?> deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        try {
            return this.jsonSerializableType.cast(this.readJson.invokeStatic(AzureJsonUtils.createReader(p)));
        }
        catch (Exception e) {
            IOException ioException = e instanceof IOException ? (IOException)e : new IOException(e);
            throw LOGGER.logThrowableAsError(ioException);
        }
    }
}

