/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.core.util;

import com.dataiku.dss.shadelibazure.com.azure.core.util.CoreUtils;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class AuthorizationChallengeHandler {
    private static final String BASIC = "Basic ";
    private static final String DIGEST = "Digest ";
    private static final String ALGORITHM = "algorithm";
    private static final String REALM = "realm";
    private static final String NONCE = "nonce";
    private static final String QOP = "qop";
    private static final String AUTH = "auth";
    private static final String AUTH_INT = "auth-int";
    private static final String USERHASH = "userhash";
    private static final String OPAQUE = "opaque";
    private static final String NEXT_NONCE = "nextnonce";
    private static final String SESS = "-SESS";
    private static final String SHA_512_256 = "SHA-512-256";
    private static final String SHA_512_256_SESS = "SHA-512-256-SESS";
    private static final String SHA_256 = "SHA-256";
    private static final String SHA_256_SESS = "SHA-256-SESS";
    private static final String MD5 = "MD5";
    private static final String MD5_SESS = "MD5-SESS";
    private static final String[] ALGORITHM_PREFERENCE_ORDER = new String[]{"SHA-512-256", "SHA-512-256-SESS", "SHA-256", "SHA-256-SESS", "MD5", "MD5-SESS"};
    public static final String WWW_AUTHENTICATE = "WWW-Authenticate";
    public static final String PROXY_AUTHENTICATE = "Proxy-Authenticate";
    public static final String AUTHORIZATION = "Authorization";
    public static final String PROXY_AUTHORIZATION = "Proxy-Authorization";
    public static final String AUTHENTICATION_INFO = "Authentication-Info";
    public static final String PROXY_AUTHENTICATION_INFO = "Proxy-Authentication-Info";
    private final String username;
    private final String password;
    private final Map<String, AtomicInteger> nonceTracker = new ConcurrentHashMap<String, AtomicInteger>();
    private final AtomicReference<String> authorizationPipeliningType = new AtomicReference();
    private final AtomicReference<ConcurrentHashMap<String, String>> lastChallenge = new AtomicReference();
    private final SecureRandom nonceGenerator = new SecureRandom();

    public AuthorizationChallengeHandler(String username, String password) {
        this.username = Objects.requireNonNull(username, "'username' cannot be null.");
        this.password = Objects.requireNonNull(password, "'password' cannot be null.");
    }

    public final String handleBasic() {
        this.authorizationPipeliningType.set(BASIC);
        String token = this.username + ":" + this.password;
        return BASIC + Base64.getEncoder().encodeToString(token.getBytes(StandardCharsets.UTF_8));
    }

    public final String handleDigest(String method, String uri, List<Map<String, String>> challenges, Supplier<byte[]> entityBodySupplier) {
        this.authorizationPipeliningType.set(DIGEST);
        Map<String, List<Map<String, String>>> challengesByType = AuthorizationChallengeHandler.partitionByChallengeType(challenges);
        for (String algorithm : ALGORITHM_PREFERENCE_ORDER) {
            Function<byte[], byte[]> digestFunction;
            if (!challengesByType.containsKey(algorithm) || (digestFunction = AuthorizationChallengeHandler.getDigestFunction(algorithm)) == null) continue;
            ConcurrentHashMap<String, String> challenge = new ConcurrentHashMap<String, String>(challengesByType.get(algorithm).get(0));
            this.lastChallenge.set(challenge);
            return this.createDigestAuthorizationHeader(method, uri, challenge, algorithm, entityBodySupplier, digestFunction);
        }
        return null;
    }

    public final String attemptToPipelineAuthorization(String method, String uri, Supplier<byte[]> entityBodySupplier) {
        String pipeliningType = this.authorizationPipeliningType.get();
        if (DIGEST.equals(pipeliningType)) {
            HashMap<String, String> challenge = new HashMap<String, String>((Map)this.lastChallenge.get());
            String algorithm = (String)challenge.get(ALGORITHM);
            if (algorithm == null) {
                algorithm = MD5;
            }
            return this.createDigestAuthorizationHeader(method, uri, challenge, algorithm, entityBodySupplier, AuthorizationChallengeHandler.getDigestFunction(algorithm));
        }
        if (BASIC.equals(pipeliningType)) {
            return this.handleBasic();
        }
        return null;
    }

    public final void consumeAuthenticationInfoHeader(Map<String, String> authenticationInfoMap) {
        if (CoreUtils.isNullOrEmpty(authenticationInfoMap)) {
            return;
        }
        if (authenticationInfoMap.containsKey(NEXT_NONCE)) {
            this.lastChallenge.get().put(NONCE, authenticationInfoMap.get(NEXT_NONCE));
        }
    }

    public static Map<String, String> parseAuthenticationOrAuthorizationHeader(String header) {
        if (CoreUtils.isNullOrEmpty(header)) {
            return Collections.emptyMap();
        }
        if (header.startsWith(BASIC) || header.startsWith(DIGEST)) {
            header = header.split(" ", 2)[1];
        }
        return Stream.of(header.split(",")).map(String::trim).map(kvp -> kvp.split("=", 2)).collect(Collectors.toMap(kvpPieces -> kvpPieces[0].toLowerCase(Locale.ROOT), kvpPieces -> kvpPieces[1].replace("\"", "")));
    }

    private String createDigestAuthorizationHeader(String method, String uri, Map<String, String> challenge, String algorithm, Supplier<byte[]> entityBodySupplier, Function<byte[], byte[]> digestFunction) {
        String realm = challenge.get(REALM);
        String nonce = challenge.get(NONCE);
        String qop = this.getQop(challenge.get(QOP));
        String opaque = challenge.get(OPAQUE);
        boolean hashUsername = Boolean.parseBoolean(challenge.get(USERHASH));
        int nc = 0;
        String clientNonce = null;
        if (AUTH.equals(qop) || AUTH_INT.equals(qop)) {
            clientNonce = this.generateNonce();
            nc = this.getNc(challenge);
        } else if (algorithm.endsWith(SESS)) {
            clientNonce = this.generateNonce();
        }
        String ha1 = algorithm.endsWith(SESS) ? AuthorizationChallengeHandler.calculateHa1Sess(digestFunction, this.username, realm, this.password, nonce, clientNonce) : AuthorizationChallengeHandler.calculateHa1NoSess(digestFunction, this.username, realm, this.password);
        String ha2 = AUTH_INT.equals(qop) ? AuthorizationChallengeHandler.calculateHa2AuthIntQop(digestFunction, method, uri, entityBodySupplier.get()) : AuthorizationChallengeHandler.calculateHa2AuthQopOrEmpty(digestFunction, method, uri);
        String response = AUTH.equals(qop) || AUTH_INT.equals(qop) ? AuthorizationChallengeHandler.calculateResponseKnownQop(digestFunction, ha1, nonce, nc, clientNonce, qop, ha2) : AuthorizationChallengeHandler.calculateResponseUnknownQop(digestFunction, ha1, nonce, ha2);
        String headerUsername = hashUsername ? AuthorizationChallengeHandler.calculateUserhash(digestFunction, this.username, realm) : this.username;
        return AuthorizationChallengeHandler.buildAuthorizationHeader(headerUsername, realm, uri, algorithm, nonce, nc, clientNonce, qop, response, opaque, hashUsername);
    }

    private int getNc(Map<String, String> challenge) {
        return this.nonceTracker.compute(challenge.get(NONCE), (ignored, value) -> {
            if (value == null) {
                return new AtomicInteger(1);
            }
            value.incrementAndGet();
            return value;
        }).get();
    }

    private String getQop(String qopHeader) {
        if (CoreUtils.isNullOrEmpty(qopHeader)) {
            return null;
        }
        if (qopHeader.equalsIgnoreCase(AUTH)) {
            return AUTH;
        }
        if (qopHeader.equalsIgnoreCase(AUTH_INT)) {
            return AUTH_INT;
        }
        return null;
    }

    private static String calculateHa1NoSess(Function<byte[], byte[]> digestFunction, String username, String realm, String password) {
        return CoreUtils.bytesToHexString(digestFunction.apply((username + ":" + realm + ":" + password).getBytes(StandardCharsets.UTF_8)));
    }

    private static String calculateHa1Sess(Function<byte[], byte[]> digestFunction, String username, String realm, String password, String nonce, String cnonce) {
        String ha1NoSess = AuthorizationChallengeHandler.calculateHa1NoSess(digestFunction, username, realm, password);
        return CoreUtils.bytesToHexString(digestFunction.apply((ha1NoSess + ":" + nonce + ":" + cnonce).getBytes(StandardCharsets.UTF_8)));
    }

    private static String calculateHa2AuthQopOrEmpty(Function<byte[], byte[]> digestFunction, String httpMethod, String uri) {
        return CoreUtils.bytesToHexString(digestFunction.apply((httpMethod + ":" + uri).getBytes(StandardCharsets.UTF_8)));
    }

    private static String calculateHa2AuthIntQop(Function<byte[], byte[]> digestFunction, String httpMethod, String uri, byte[] requestEntityBody) {
        String bodyHex = CoreUtils.bytesToHexString(digestFunction.apply(requestEntityBody));
        return CoreUtils.bytesToHexString(digestFunction.apply((httpMethod + ":" + uri + ":" + bodyHex).getBytes(StandardCharsets.UTF_8)));
    }

    private static String calculateResponseUnknownQop(Function<byte[], byte[]> digestFunction, String ha1, String nonce, String ha2) {
        return CoreUtils.bytesToHexString(digestFunction.apply((ha1 + ":" + nonce + ":" + ha2).getBytes(StandardCharsets.UTF_8)));
    }

    private static String calculateResponseKnownQop(Function<byte[], byte[]> digestFunction, String ha1, String nonce, int nc, String cnonce, String qop, String ha2) {
        String zeroPadNc = String.format("%08X", nc);
        return CoreUtils.bytesToHexString(digestFunction.apply((ha1 + ":" + nonce + ":" + zeroPadNc + ":" + cnonce + ":" + qop + ":" + ha2).getBytes(StandardCharsets.UTF_8)));
    }

    private static String calculateUserhash(Function<byte[], byte[]> digestFunction, String username, String realm) {
        return CoreUtils.bytesToHexString(digestFunction.apply((username + ":" + realm).getBytes(StandardCharsets.UTF_8)));
    }

    private static Function<byte[], byte[]> getDigestFunction(String algorithm) {
        if (algorithm.endsWith(SESS)) {
            algorithm = algorithm.substring(0, algorithm.length() - SESS.length());
        }
        try {
            if (SHA_512_256.equals(algorithm)) {
                MessageDigest digest = MessageDigest.getInstance("SHA-512");
                return bytes -> Arrays.copyOf(digest.digest((byte[])bytes), 32);
            }
            MessageDigest digest = MessageDigest.getInstance(algorithm);
            return digest::digest;
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
    }

    private static Map<String, List<Map<String, String>>> partitionByChallengeType(List<Map<String, String>> challenges) {
        return challenges.stream().collect(Collectors.groupingBy(headers -> {
            String algorithmHeader = (String)headers.get(ALGORITHM);
            return algorithmHeader == null ? MD5 : algorithmHeader.toUpperCase(Locale.ROOT);
        }));
    }

    String generateNonce() {
        byte[] nonce = new byte[16];
        this.nonceGenerator.nextBytes(nonce);
        return CoreUtils.bytesToHexString(nonce);
    }

    private static String buildAuthorizationHeader(String username, String realm, String uri, String algorithm, String nonce, int nc, String cnonce, String qop, String response, String opaque, boolean userhash) {
        StringBuilder authorizationBuilder = new StringBuilder(512);
        authorizationBuilder.append(DIGEST).append("username=\"").append(username).append("\", ").append("realm=\"").append(realm).append("\", ").append("nonce=\"").append(nonce).append("\", ").append("uri=\"").append(uri).append("\", ").append("response=\"").append(response).append("\"");
        if (!CoreUtils.isNullOrEmpty(algorithm)) {
            authorizationBuilder.append(", algorithm=").append(algorithm);
        }
        if (!CoreUtils.isNullOrEmpty(cnonce)) {
            authorizationBuilder.append(", cnonce=\"").append(cnonce).append("\"");
        }
        if (!CoreUtils.isNullOrEmpty(opaque)) {
            authorizationBuilder.append(", opaque=\"").append(opaque).append("\"");
        }
        if (!CoreUtils.isNullOrEmpty(qop)) {
            authorizationBuilder.append(", qop=").append(qop);
            authorizationBuilder.append(", nc=").append(String.format("%08X", nc));
        }
        if (userhash) {
            authorizationBuilder.append(", userhash=true");
        }
        return authorizationBuilder.toString();
    }
}

