/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.core.util;

import com.dataiku.dss.shadelibazure.com.azure.core.util.Base64Util;
import com.dataiku.dss.shadelibazure.com.azure.core.util.CoreUtils;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;

public final class Base64Url {
    private final byte[] bytes;

    public Base64Url(String string) {
        if (string == null) {
            this.bytes = null;
        } else {
            string = Base64Url.unquote(string);
            this.bytes = string.getBytes(StandardCharsets.UTF_8);
        }
    }

    public Base64Url(byte[] bytes) {
        this.bytes = Base64Url.unquote(bytes);
    }

    private static byte[] unquote(byte[] bytes) {
        byte lastByte;
        byte firstByte;
        if (bytes != null && bytes.length > 1 && ((firstByte = bytes[0]) == 34 || firstByte == 39) && (lastByte = bytes[bytes.length - 1]) == firstByte) {
            return Arrays.copyOfRange(bytes, 1, bytes.length - 1);
        }
        return bytes;
    }

    private static String unquote(String string) {
        int base64UrlStringLength;
        char lastCharacter;
        char firstCharacter;
        if (!(CoreUtils.isNullOrEmpty(string) || (firstCharacter = string.charAt(0)) != '\"' && firstCharacter != '\'' || (lastCharacter = string.charAt((base64UrlStringLength = string.length()) - 1)) != firstCharacter)) {
            return string.substring(1, base64UrlStringLength - 1);
        }
        return string;
    }

    public static Base64Url encode(byte[] bytes) {
        if (bytes == null) {
            return new Base64Url((String)null);
        }
        return new Base64Url(Base64Util.encodeURLWithoutPadding(bytes));
    }

    public byte[] encodedBytes() {
        return CoreUtils.clone(this.bytes);
    }

    public byte[] decodedBytes() {
        if (this.bytes == null) {
            return null;
        }
        return Base64Util.decodeURL(this.bytes);
    }

    public String toString() {
        return this.bytes == null ? "" : new String(this.bytes, StandardCharsets.UTF_8);
    }

    public int hashCode() {
        return Arrays.hashCode(this.bytes);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Base64Url)) {
            return false;
        }
        return Arrays.equals(this.bytes, ((Base64Url)obj).encodedBytes());
    }
}

