/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.core.util;

import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import java.util.Objects;

public final class ETag {
    private static final ClientLogger LOGGER = new ClientLogger(ETag.class);
    private static final String QUOTE_STRING = "\"";
    private static final String WEAK_ETAG_PREFIX_QUOTE = "W/\"";
    private static final String ASTERISK = "*";
    public static final ETag ALL = new ETag("*");
    private final String eTag;

    public ETag(String eTag) {
        this.checkValidETag(eTag);
        this.eTag = eTag;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ETag)) {
            return false;
        }
        return Objects.equals(this.eTag, ((ETag)o).eTag);
    }

    public int hashCode() {
        return Objects.hashCode(this.eTag);
    }

    public String toString() {
        return this.eTag;
    }

    private void checkValidETag(String eTag) {
        if (eTag == null || ASTERISK.equals(eTag)) {
            return;
        }
        if (!eTag.startsWith(QUOTE_STRING) && !eTag.startsWith(WEAK_ETAG_PREFIX_QUOTE) || !eTag.endsWith(QUOTE_STRING)) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(String.format("The value=%s should be equal to * , be wrapped in quotes, or be wrapped in quotes prefixed by W/", eTag)));
        }
    }
}

