/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.core.util;

import com.dataiku.dss.shadelibazure.com.azure.core.implementation.ImplUtils;
import com.dataiku.dss.shadelibazure.com.azure.core.util.CoreUtils;
import com.dataiku.dss.shadelibazure.com.azure.core.util.QueryParameter;
import com.dataiku.dss.shadelibazure.com.azure.core.util.UrlToken;
import com.dataiku.dss.shadelibazure.com.azure.core.util.UrlTokenType;
import com.dataiku.dss.shadelibazure.com.azure.core.util.UrlTokenizer;
import com.dataiku.dss.shadelibazure.com.azure.core.util.UrlTokenizerState;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

public final class UrlBuilder {
    private static final Map<String, UrlBuilder> PARSED_URLS = new ConcurrentHashMap<String, UrlBuilder>();
    private static final URL HTTP;
    private static final URL HTTPS;
    private String scheme;
    private String host;
    private Integer port;
    private String path;
    private Map<String, QueryParameter> queryToCopy;
    private Map<String, QueryParameter> query;

    public UrlBuilder() {
        this(null);
    }

    private UrlBuilder(Map<String, QueryParameter> queryToCopy) {
        this.queryToCopy = queryToCopy;
    }

    public UrlBuilder setScheme(String scheme) {
        if (scheme == null || scheme.isEmpty()) {
            this.scheme = null;
        } else {
            this.with(scheme, UrlTokenizerState.SCHEME);
        }
        return this;
    }

    public String getScheme() {
        return this.scheme;
    }

    public UrlBuilder setHost(String host) {
        if (host == null || host.isEmpty()) {
            this.host = null;
        } else {
            this.with(host, UrlTokenizerState.SCHEME_OR_HOST);
        }
        return this;
    }

    public String getHost() {
        return this.host;
    }

    public UrlBuilder setPort(String port) {
        if (CoreUtils.isNullOrEmpty(port)) {
            this.port = null;
            return this;
        }
        return this.with(port, UrlTokenizerState.PORT);
    }

    public UrlBuilder setPort(int port) {
        this.port = port;
        return this;
    }

    public Integer getPort() {
        return this.port;
    }

    public UrlBuilder setPath(String path) {
        if (path == null || path.isEmpty()) {
            this.path = null;
        } else {
            this.with(path, UrlTokenizerState.PATH);
        }
        return this;
    }

    public String getPath() {
        return this.path;
    }

    public UrlBuilder setQueryParameter(String queryParameterName, String queryParameterEncodedValue) {
        this.initializeQuery();
        this.query.put(queryParameterName, new QueryParameter(queryParameterName, queryParameterEncodedValue));
        return this;
    }

    public UrlBuilder addQueryParameter(String queryParameterName, String queryParameterEncodedValue) {
        this.initializeQuery();
        this.query.compute(queryParameterName, (key, value) -> {
            if (value == null) {
                return new QueryParameter(queryParameterName, queryParameterEncodedValue);
            }
            value.addValue(queryParameterEncodedValue);
            return value;
        });
        return this;
    }

    public UrlBuilder setQuery(String query) {
        return query == null || query.isEmpty() ? this.clearQuery() : this.with(query, UrlTokenizerState.QUERY);
    }

    public UrlBuilder clearQuery() {
        if (CoreUtils.isNullOrEmpty(this.query)) {
            return this;
        }
        this.query.clear();
        return this;
    }

    public Map<String, String> getQuery() {
        this.initializeQuery();
        return this.query.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((QueryParameter)entry.getValue()).getValue()));
    }

    public String getQueryString() {
        if (CoreUtils.isNullOrEmpty(this.queryToCopy) && CoreUtils.isNullOrEmpty(this.query)) {
            return "";
        }
        StringBuilder queryBuilder = new StringBuilder();
        this.appendQueryString(queryBuilder);
        return queryBuilder.toString();
    }

    private void appendQueryString(StringBuilder stringBuilder) {
        if (CoreUtils.isNullOrEmpty(this.queryToCopy) && CoreUtils.isNullOrEmpty(this.query)) {
            return;
        }
        stringBuilder.append('?');
        boolean first = true;
        if (this.query == null) {
            this.query = new LinkedHashMap<String, QueryParameter>(this.queryToCopy.size());
            for (Map.Entry<String, QueryParameter> entry : this.queryToCopy.entrySet()) {
                first = UrlBuilder.writeQueryValues(stringBuilder, entry.getKey(), entry.getValue().getValuesList(), first);
                this.query.put(entry.getKey(), entry.getValue());
            }
        } else {
            for (Map.Entry<String, QueryParameter> entry : this.query.entrySet()) {
                first = UrlBuilder.writeQueryValues(stringBuilder, entry.getKey(), entry.getValue().getValuesList(), first);
            }
        }
    }

    private static boolean writeQueryValues(StringBuilder builder, String key, List<String> values2, boolean first) {
        for (String value : values2) {
            if (!first) {
                builder.append('&');
            }
            builder.append(key).append('=').append(value);
            first = false;
        }
        return first;
    }

    private UrlBuilder with(String text, UrlTokenizerState startState) {
        UrlTokenizer tokenizer = new UrlTokenizer(text, startState);
        while (tokenizer.next()) {
            UrlToken token = tokenizer.current();
            String tokenText = UrlBuilder.emptyToNull(token.text());
            UrlTokenType tokenType = token.type();
            switch (tokenType) {
                case SCHEME: {
                    this.scheme = tokenText;
                    break;
                }
                case HOST: {
                    this.host = tokenText;
                    break;
                }
                case PORT: {
                    this.port = tokenText == null ? null : Integer.valueOf(Integer.parseInt(tokenText));
                    break;
                }
                case PATH: {
                    if (this.path != null && !"/".equals(this.path) && "/".equals(tokenText)) break;
                    this.path = tokenText;
                    break;
                }
                case QUERY: {
                    CoreUtils.parseQueryParameters(tokenText).forEachRemaining(queryParam -> this.addQueryParameter((String)queryParam.getKey(), (String)queryParam.getValue()));
                    break;
                }
            }
        }
        return this;
    }

    public URL toUrl() throws MalformedURLException {
        if ("http".equals(this.scheme)) {
            return new URL(HTTP, this.toString());
        }
        if ("https".equals(this.scheme)) {
            return new URL(HTTPS, this.toString());
        }
        return ImplUtils.createUrl(this.toString());
    }

    public String toString() {
        boolean isAbsolutePath;
        StringBuilder result = new StringBuilder();
        boolean bl = isAbsolutePath = this.path != null && (this.path.startsWith("http://") || this.path.startsWith("https://"));
        if (!isAbsolutePath) {
            if (this.scheme != null) {
                result.append(this.scheme);
                if (!this.scheme.endsWith("://")) {
                    result.append("://");
                }
            }
            if (this.host != null) {
                result.append(this.host);
            }
        }
        if (this.port != null) {
            result.append(':');
            result.append(this.port);
        }
        if (this.path != null) {
            if (result.length() != 0 && !this.path.startsWith("/")) {
                result.append('/');
            }
            result.append(this.path);
        }
        this.appendQueryString(result);
        return result.toString();
    }

    static Map<String, UrlBuilder> getParsedUrls() {
        return PARSED_URLS;
    }

    public static UrlBuilder parse(String url) {
        String concurrentSafeUrl;
        String string = concurrentSafeUrl = url == null ? "" : url;
        if (PARSED_URLS.size() >= 10000) {
            PARSED_URLS.clear();
        }
        return PARSED_URLS.computeIfAbsent(concurrentSafeUrl, u -> new UrlBuilder().with((String)u, UrlTokenizerState.SCHEME_OR_HOST)).copy();
    }

    public static UrlBuilder parse(URL url) {
        return ImplUtils.parseUrl(url, true);
    }

    private static String emptyToNull(String value) {
        return value == null || value.isEmpty() ? null : value;
    }

    private UrlBuilder copy() {
        UrlBuilder copy = new UrlBuilder(this.query);
        copy.scheme = this.scheme;
        copy.host = this.host;
        copy.path = this.path;
        copy.port = this.port;
        return copy;
    }

    private void initializeQuery() {
        if (this.query == null) {
            this.query = new LinkedHashMap<String, QueryParameter>();
        }
        if (this.queryToCopy != null) {
            this.query.putAll(this.queryToCopy);
            this.queryToCopy = null;
        }
    }

    static {
        try {
            HTTP = new URL("http://azure.com");
            HTTPS = new URL("https://azure.com");
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }
}

