/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.core.util.polling;

import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.core.util.polling.LongRunningOperationStatus;
import com.dataiku.dss.shadelibazure.com.azure.core.util.polling.PollResponse;
import com.dataiku.dss.shadelibazure.com.azure.core.util.polling.PollingContext;
import com.dataiku.dss.shadelibazure.com.azure.core.util.polling.PollingUtil;
import com.dataiku.dss.shadelibazure.com.azure.core.util.polling.SyncPoller;
import com.dataiku.dss.shadelibazure.com.azure.core.util.polling.implementation.PollContextRequiredException;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.Semaphore;
import java.util.function.BiFunction;
import java.util.function.Function;

final class SimpleSyncPoller<T, U>
implements SyncPoller<T, U> {
    private static final ClientLogger LOGGER = new ClientLogger(SimpleSyncPoller.class);
    private final Function<PollingContext<T>, PollResponse<T>> pollOperation;
    private final BiFunction<PollingContext<T>, PollResponse<T>, T> cancelOperation;
    private final Function<PollingContext<T>, U> fetchResultOperation;
    private final PollResponse<T> activationResponse;
    private final PollingContext<T> pollingContext = new PollingContext();
    private final Semaphore pollingSemaphore = new Semaphore(1);
    private volatile PollingContext<T> terminalPollContext;
    private volatile Duration pollInterval;

    SimpleSyncPoller(Duration pollInterval, Function<PollingContext<T>, PollResponse<T>> syncActivationOperation, Function<PollingContext<T>, PollResponse<T>> pollOperation, BiFunction<PollingContext<T>, PollResponse<T>, T> cancelOperation, Function<PollingContext<T>, U> fetchResultOperation) {
        Objects.requireNonNull(pollInterval, "'pollInterval' cannot be null.");
        if (pollInterval.isNegative() || pollInterval.isZero()) {
            throw LOGGER.logExceptionAsWarning(new IllegalArgumentException("Negative or zero value for 'defaultPollInterval' is not allowed."));
        }
        this.pollInterval = pollInterval;
        Objects.requireNonNull(syncActivationOperation, "'syncActivationOperation' cannot be null.");
        this.pollOperation = Objects.requireNonNull(pollOperation, "'pollOperation' cannot be null.");
        this.cancelOperation = Objects.requireNonNull(cancelOperation, "'cancelOperation' cannot be null.");
        this.fetchResultOperation = Objects.requireNonNull(fetchResultOperation, "'fetchResultOperation' cannot be null.");
        this.activationResponse = syncActivationOperation.apply(this.pollingContext);
        this.pollingContext.setOnetimeActivationResponse(this.activationResponse);
        this.pollingContext.setLatestResponse(this.activationResponse);
        if (this.activationResponse.getStatus().isComplete()) {
            this.terminalPollContext = this.pollingContext;
        }
    }

    @Override
    public PollResponse<T> poll() {
        try {
            this.pollingSemaphore.acquire();
        }
        catch (InterruptedException e) {
            throw LOGGER.logExceptionAsError(new RuntimeException(e));
        }
        try {
            PollResponse<T> response = this.pollOperation.apply(this.pollingContext);
            this.pollingContext.setLatestResponse(response);
            if (response.getStatus().isComplete()) {
                this.terminalPollContext = this.pollingContext.copy();
            }
            PollResponse<T> pollResponse = response;
            return pollResponse;
        }
        finally {
            this.pollingSemaphore.release();
        }
    }

    @Override
    public PollResponse<T> waitForCompletion() {
        return this.waitForCompletionHelper(null);
    }

    @Override
    public PollResponse<T> waitForCompletion(Duration timeout2) {
        PollingUtil.validateTimeout(timeout2, LOGGER);
        return this.waitForCompletionHelper(timeout2);
    }

    @Override
    public PollResponse<T> waitUntil(LongRunningOperationStatus statusToWaitFor) {
        Objects.requireNonNull(statusToWaitFor, "'statusToWaitFor' cannot be null.");
        return this.waitUntilHelper(null, statusToWaitFor);
    }

    @Override
    public PollResponse<T> waitUntil(Duration timeout2, LongRunningOperationStatus statusToWaitFor) {
        PollingUtil.validateTimeout(timeout2, LOGGER);
        Objects.requireNonNull(statusToWaitFor, "'statusToWaitFor' cannot be null.");
        return this.waitUntilHelper(timeout2, statusToWaitFor);
    }

    private PollResponse<T> waitUntilHelper(Duration timeout2, LongRunningOperationStatus statusToWaitFor) {
        PollingContext<T> currentTerminalPollContext = this.terminalPollContext;
        if (currentTerminalPollContext != null) {
            return currentTerminalPollContext.getLatestResponse();
        }
        PollingContext<T> context = this.pollingContext.copy();
        PollResponse<T> pollResponse = PollingUtil.pollingLoop(context, timeout2, statusToWaitFor, this.pollOperation, this.pollInterval, true);
        if (pollResponse.getStatus().isComplete()) {
            this.terminalPollContext = context;
        }
        return pollResponse;
    }

    private PollResponse<T> waitForCompletionHelper(Duration timeout2) {
        PollingContext<T> currentTerminalPollContext = this.terminalPollContext;
        if (currentTerminalPollContext != null) {
            return currentTerminalPollContext.getLatestResponse();
        }
        PollingContext<T> context = this.pollingContext.copy();
        PollResponse<T> pollResponse = PollingUtil.pollingLoop(context, timeout2, null, this.pollOperation, this.pollInterval, false);
        this.terminalPollContext = context;
        return pollResponse;
    }

    @Override
    public U getFinalResult() {
        return this.getFinalResultHelper(null);
    }

    @Override
    public U getFinalResult(Duration timeout2) {
        PollingUtil.validateTimeout(timeout2, LOGGER);
        return this.getFinalResultHelper(timeout2);
    }

    private U getFinalResultHelper(Duration timeout2) {
        PollingContext<T> currentTerminalPollContext = this.terminalPollContext;
        if (currentTerminalPollContext != null) {
            return this.fetchResultOperation.apply(currentTerminalPollContext);
        }
        PollingContext<T> context = this.pollingContext.copy();
        PollingUtil.pollingLoop(context, timeout2, null, this.pollOperation, this.pollInterval, false);
        this.terminalPollContext = context;
        return this.getFinalResult();
    }

    @Override
    public void cancelOperation() {
        PollingContext<T> context1 = this.pollingContext.copy();
        if (context1.getActivationResponse() == context1.getLatestResponse()) {
            this.cancelOperation.apply(context1, context1.getActivationResponse());
        } else {
            try {
                this.cancelOperation.apply(null, this.activationResponse);
            }
            catch (PollContextRequiredException crp) {
                PollingContext<T> context2 = this.pollingContext.copy();
                PollingUtil.pollingLoop(this.pollingContext, null, null, this.pollOperation, this.pollInterval, false);
                this.cancelOperation.apply(context2, this.activationResponse);
            }
        }
    }

    @Override
    public SyncPoller<T, U> setPollInterval(Duration pollInterval) {
        this.pollInterval = PollingUtil.validatePollInterval(pollInterval, LOGGER);
        return this;
    }
}

