/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.identity;

import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.identity.AadCredentialBuilderBase;
import com.dataiku.dss.shadelibazure.com.azure.identity.ClientCertificateCredential;
import com.dataiku.dss.shadelibazure.com.azure.identity.TokenCachePersistenceOptions;
import com.dataiku.dss.shadelibazure.com.azure.identity.implementation.util.IdentityUtil;
import com.dataiku.dss.shadelibazure.com.azure.identity.implementation.util.ValidationUtil;
import java.io.InputStream;

public class ClientCertificateCredentialBuilder
extends AadCredentialBuilderBase<ClientCertificateCredentialBuilder> {
    private static final ClientLogger LOGGER = new ClientLogger(ClientCertificateCredentialBuilder.class);
    private static final String CLASS_NAME = ClientCertificateCredentialBuilder.class.getSimpleName();
    private String clientCertificatePath;
    private byte[] clientCertificateBytes;
    private String clientCertificatePassword;

    public ClientCertificateCredentialBuilder pemCertificate(String certificatePath) {
        this.clientCertificatePath = certificatePath;
        return this;
    }

    public ClientCertificateCredentialBuilder pemCertificate(InputStream certificate) {
        this.clientCertificateBytes = IdentityUtil.convertInputStreamToByteArray(certificate);
        return this;
    }

    @Deprecated
    public ClientCertificateCredentialBuilder pfxCertificate(String certificatePath, String clientCertificatePassword) {
        this.clientCertificatePath = certificatePath;
        this.clientCertificatePassword = clientCertificatePassword;
        return this;
    }

    public ClientCertificateCredentialBuilder pfxCertificate(String certificatePath) {
        this.clientCertificatePath = certificatePath;
        return this;
    }

    public ClientCertificateCredentialBuilder pfxCertificate(InputStream certificate) {
        this.clientCertificateBytes = IdentityUtil.convertInputStreamToByteArray(certificate);
        return this;
    }

    public ClientCertificateCredentialBuilder clientCertificatePassword(String clientCertificatePassword) {
        this.clientCertificatePassword = clientCertificatePassword;
        return this;
    }

    ClientCertificateCredentialBuilder allowUnencryptedCache() {
        this.identityClientOptions.setAllowUnencryptedCache(true);
        return this;
    }

    ClientCertificateCredentialBuilder enablePersistentCache() {
        this.identityClientOptions.enablePersistentCache();
        return this;
    }

    public ClientCertificateCredentialBuilder tokenCachePersistenceOptions(TokenCachePersistenceOptions tokenCachePersistenceOptions) {
        this.identityClientOptions.setTokenCacheOptions(tokenCachePersistenceOptions);
        return this;
    }

    public ClientCertificateCredentialBuilder sendCertificateChain(boolean sendCertificateChain) {
        this.identityClientOptions.setIncludeX5c(sendCertificateChain);
        return this;
    }

    public ClientCertificateCredential build() {
        ValidationUtil.validate(CLASS_NAME, LOGGER, "clientId", this.clientId, "tenantId", this.tenantId, "clientCertificate", this.clientCertificateBytes == null || this.clientCertificateBytes.length == 0 ? this.clientCertificatePath : (Object)this.clientCertificateBytes);
        if (this.clientCertificateBytes != null && this.clientCertificatePath != null) {
            throw LOGGER.logExceptionAsWarning(new IllegalArgumentException("Both certificate input stream and certificate path are provided in ClientCertificateCredentialBuilder. Only one of them should be provided."));
        }
        return new ClientCertificateCredential(this.tenantId, this.clientId, this.clientCertificatePath, this.clientCertificateBytes, this.clientCertificatePassword, this.identityClientOptions);
    }
}

