/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.identity;

import com.dataiku.dss.shadelibazure.com.azure.core.credential.AccessToken;
import com.dataiku.dss.shadelibazure.com.azure.core.credential.TokenCredential;
import com.dataiku.dss.shadelibazure.com.azure.core.credential.TokenRequestContext;
import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.identity.implementation.IdentityClient;
import com.dataiku.dss.shadelibazure.com.azure.identity.implementation.IdentityClientBuilder;
import com.dataiku.dss.shadelibazure.com.azure.identity.implementation.IdentityClientOptions;
import com.dataiku.dss.shadelibazure.com.azure.identity.implementation.IdentitySyncClient;
import com.dataiku.dss.shadelibazure.com.azure.identity.implementation.util.LoggingUtil;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import java.util.Objects;

public class ClientSecretCredential
implements TokenCredential {
    private static final ClientLogger LOGGER = new ClientLogger(ClientSecretCredential.class);
    private final IdentityClient identityClient;
    private final IdentitySyncClient identitySyncClient;

    ClientSecretCredential(String tenantId, String clientId, String clientSecret, IdentityClientOptions identityClientOptions) {
        Objects.requireNonNull(clientSecret, "'clientSecret' cannot be null.");
        Objects.requireNonNull(identityClientOptions, "'identityClientOptions' cannot be null.");
        IdentityClientBuilder builder = new IdentityClientBuilder().tenantId(tenantId).clientId(clientId).clientSecret(clientSecret).identityClientOptions(identityClientOptions);
        this.identityClient = builder.build();
        this.identitySyncClient = builder.buildSyncClient();
    }

    @Override
    public Mono<AccessToken> getToken(TokenRequestContext request) {
        return this.identityClient.authenticateWithConfidentialClientCache(request).onErrorResume(t -> Mono.empty()).switchIfEmpty(Mono.defer(() -> this.identityClient.authenticateWithConfidentialClient(request))).doOnNext(token -> LoggingUtil.logTokenSuccess(LOGGER, request)).doOnError(error -> LoggingUtil.logTokenError(LOGGER, this.identityClient.getIdentityClientOptions(), request, error));
    }

    @Override
    public AccessToken getTokenSync(TokenRequestContext request) {
        AccessToken token2;
        try {
            token2 = this.identitySyncClient.authenticateWithConfidentialClientCache(request);
            if (token2 != null) {
                LoggingUtil.logTokenSuccess(LOGGER, request);
                return token2;
            }
        }
        catch (Exception token2) {
            // empty catch block
        }
        try {
            token2 = this.identitySyncClient.authenticateWithConfidentialClient(request);
            LoggingUtil.logTokenSuccess(LOGGER, request);
            return token2;
        }
        catch (Exception e) {
            LoggingUtil.logTokenError(LOGGER, this.identityClient.getIdentityClientOptions(), request, e);
            throw e;
        }
    }
}

