/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.identity;

import com.dataiku.dss.shadelibazure.com.azure.core.credential.AccessToken;
import com.dataiku.dss.shadelibazure.com.azure.core.credential.TokenCredential;
import com.dataiku.dss.shadelibazure.com.azure.core.credential.TokenRequestContext;
import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.identity.implementation.IdentityClient;
import com.dataiku.dss.shadelibazure.com.azure.identity.implementation.IdentityClientBuilder;
import com.dataiku.dss.shadelibazure.com.azure.identity.implementation.IdentityClientOptions;
import com.dataiku.dss.shadelibazure.com.azure.identity.implementation.IdentitySyncClient;
import com.dataiku.dss.shadelibazure.com.azure.identity.implementation.util.LoggingUtil;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import java.util.function.Supplier;

public class OnBehalfOfCredential
implements TokenCredential {
    private static final ClientLogger LOGGER = new ClientLogger(OnBehalfOfCredential.class);
    private final IdentityClient identityClient;
    private final IdentitySyncClient identitySyncClient;

    OnBehalfOfCredential(String clientId, String tenantId, String clientSecret, String certificatePath, String certificatePassword, Supplier<String> clientAssertionSupplier, IdentityClientOptions identityClientOptions) {
        IdentityClientBuilder builder = new IdentityClientBuilder().tenantId(tenantId).clientId(clientId).clientSecret(clientSecret).certificatePath(certificatePath).clientAssertionSupplier(clientAssertionSupplier).certificatePassword(certificatePassword).identityClientOptions(identityClientOptions);
        this.identitySyncClient = builder.buildSyncClient();
        this.identityClient = builder.build();
    }

    @Override
    public Mono<AccessToken> getToken(TokenRequestContext request) {
        return Mono.deferContextual(ctx -> this.identityClient.authenticateWithConfidentialClientCache(request).onErrorResume(t -> Mono.empty()).switchIfEmpty(Mono.defer(() -> this.identityClient.authenticateWithOBO(request))).doOnNext(token -> LoggingUtil.logTokenSuccess(LOGGER, request)).doOnError(error -> LoggingUtil.logTokenError(LOGGER, this.identityClient.getIdentityClientOptions(), request, error)));
    }

    @Override
    public AccessToken getTokenSync(TokenRequestContext request) {
        AccessToken token2;
        try {
            token2 = this.identitySyncClient.authenticateWithConfidentialClientCache(request);
            if (token2 != null) {
                LoggingUtil.logTokenSuccess(LOGGER, request);
                return token2;
            }
        }
        catch (Exception token2) {
            // empty catch block
        }
        try {
            token2 = this.identitySyncClient.authenticateWithOBO(request);
            LoggingUtil.logTokenSuccess(LOGGER, request);
            return token2;
        }
        catch (Exception e) {
            LoggingUtil.logTokenError(LOGGER, this.identityClient.getIdentityClientOptions(), request, e);
            throw e;
        }
    }
}

