/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.identity;

import com.dataiku.dss.shadelibazure.com.azure.core.credential.AccessToken;
import com.dataiku.dss.shadelibazure.com.azure.core.credential.TokenCredential;
import com.dataiku.dss.shadelibazure.com.azure.core.credential.TokenRequestContext;
import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.identity.AuthenticationRecord;
import com.dataiku.dss.shadelibazure.com.azure.identity.AzureAuthorityHosts;
import com.dataiku.dss.shadelibazure.com.azure.identity.CredentialUnavailableException;
import com.dataiku.dss.shadelibazure.com.azure.identity.implementation.IdentityClient;
import com.dataiku.dss.shadelibazure.com.azure.identity.implementation.IdentityClientBuilder;
import com.dataiku.dss.shadelibazure.com.azure.identity.implementation.IdentityClientOptions;
import com.dataiku.dss.shadelibazure.com.azure.identity.implementation.IdentitySyncClient;
import com.dataiku.dss.shadelibazure.com.azure.identity.implementation.MsalAuthenticationAccount;
import com.dataiku.dss.shadelibazure.com.azure.identity.implementation.MsalToken;
import com.dataiku.dss.shadelibazure.com.azure.identity.implementation.util.LoggingUtil;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;

public class UsernamePasswordCredential
implements TokenCredential {
    private static final ClientLogger LOGGER = new ClientLogger(UsernamePasswordCredential.class);
    private final String username;
    private final String password;
    private final IdentityClient identityClient;
    private final IdentitySyncClient identitySyncClient;
    private final String authorityHost;
    private final AtomicReference<MsalAuthenticationAccount> cachedToken;
    private boolean isCaeEnabledRequestCached;
    private boolean isCaeDisabledRequestCached;
    private boolean isCachePopulated;

    UsernamePasswordCredential(String clientId, String tenantId, String username, String password, IdentityClientOptions identityClientOptions) {
        Objects.requireNonNull(username, "'username' cannot be null.");
        Objects.requireNonNull(password, "'password' cannot be null.");
        this.username = username;
        this.password = password;
        IdentityClientBuilder builder = new IdentityClientBuilder().tenantId(tenantId).clientId(clientId).identityClientOptions(identityClientOptions);
        this.identityClient = builder.build();
        this.identitySyncClient = builder.buildSyncClient();
        this.cachedToken = new AtomicReference();
        this.authorityHost = identityClientOptions.getAuthorityHost();
    }

    @Override
    public Mono<AccessToken> getToken(TokenRequestContext request) {
        return Mono.defer(() -> {
            this.isCachePopulated = this.isCachePopulated(request);
            if (this.isCachePopulated) {
                return this.identityClient.authenticateWithPublicClientCache(request, this.cachedToken.get()).onErrorResume(t -> Mono.empty());
            }
            return Mono.empty();
        }).switchIfEmpty(Mono.defer(() -> this.identityClient.authenticateWithUsernamePassword(request, this.username, this.password))).map(msalToken -> {
            AccessToken accessToken = this.updateCache((MsalToken)msalToken);
            if (request.isCaeEnabled()) {
                this.isCaeEnabledRequestCached = true;
            } else {
                this.isCaeDisabledRequestCached = true;
            }
            return accessToken;
        }).doOnNext(token -> LoggingUtil.logTokenSuccess(LOGGER, request)).doOnError(error -> LoggingUtil.logTokenError(LOGGER, this.identityClient.getIdentityClientOptions(), request, error));
    }

    @Override
    public AccessToken getTokenSync(TokenRequestContext request) {
        if (this.cachedToken.get() != null) {
            try {
                MsalToken token = this.identitySyncClient.authenticateWithPublicClientCache(request, this.cachedToken.get());
                if (token != null) {
                    LoggingUtil.logTokenSuccess(LOGGER, request);
                    return token;
                }
            }
            catch (Exception token) {
                // empty catch block
            }
        }
        try {
            MsalToken accessToken = this.identitySyncClient.authenticateWithUsernamePassword(request, this.username, this.password);
            this.updateCache(accessToken);
            LoggingUtil.logTokenSuccess(LOGGER, request);
            return accessToken;
        }
        catch (Exception e) {
            LoggingUtil.logTokenError(LOGGER, this.identityClient.getIdentityClientOptions(), request, e);
            throw e;
        }
    }

    public Mono<AuthenticationRecord> authenticate(TokenRequestContext request) {
        return Mono.defer(() -> this.identityClient.authenticateWithUsernamePassword(request, this.username, this.password)).map(this::updateCache).map(msalToken -> this.cachedToken.get().getAuthenticationRecord());
    }

    public Mono<AuthenticationRecord> authenticate() {
        String defaultScope = AzureAuthorityHosts.getDefaultScope(this.authorityHost);
        if (defaultScope == null) {
            return Mono.error(LoggingUtil.logCredentialUnavailableException(LOGGER, this.identityClient.getIdentityClientOptions(), new CredentialUnavailableException("Authenticating in this environment requires specifying a TokenRequestContext.")));
        }
        return this.authenticate(new TokenRequestContext().addScopes(defaultScope));
    }

    private AccessToken updateCache(MsalToken msalToken) {
        this.cachedToken.set(new MsalAuthenticationAccount(new AuthenticationRecord(msalToken.getAuthenticationResult(), this.identityClient.getTenantId(), this.identityClient.getClientId()), msalToken.getAccount().getTenantProfiles()));
        return msalToken;
    }

    private boolean isCachePopulated(TokenRequestContext request) {
        return this.cachedToken.get() != null && (request.isCaeEnabled() && this.isCaeEnabledRequestCached || !request.isCaeEnabled() && this.isCaeDisabledRequestCached);
    }
}

