/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.identity;

import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.identity.AadCredentialBuilderBase;
import com.dataiku.dss.shadelibazure.com.azure.identity.TokenCachePersistenceOptions;
import com.dataiku.dss.shadelibazure.com.azure.identity.UsernamePasswordCredential;
import com.dataiku.dss.shadelibazure.com.azure.identity.implementation.util.IdentityUtil;
import com.dataiku.dss.shadelibazure.com.azure.identity.implementation.util.ValidationUtil;
import java.util.Arrays;
import java.util.List;

public class UsernamePasswordCredentialBuilder
extends AadCredentialBuilderBase<UsernamePasswordCredentialBuilder> {
    private static final ClientLogger LOGGER = new ClientLogger(UsernamePasswordCredentialBuilder.class);
    private static final String CLASS_NAME = UsernamePasswordCredentialBuilder.class.getSimpleName();
    private String username;
    private String password;

    public UsernamePasswordCredentialBuilder username(String username) {
        this.username = username;
        return this;
    }

    public UsernamePasswordCredentialBuilder password(String password) {
        this.password = password;
        return this;
    }

    public UsernamePasswordCredentialBuilder tokenCachePersistenceOptions(TokenCachePersistenceOptions tokenCachePersistenceOptions) {
        this.identityClientOptions.setTokenCacheOptions(tokenCachePersistenceOptions);
        return this;
    }

    UsernamePasswordCredentialBuilder allowUnencryptedCache() {
        this.identityClientOptions.setAllowUnencryptedCache(true);
        return this;
    }

    UsernamePasswordCredentialBuilder enablePersistentCache() {
        this.identityClientOptions.enablePersistentCache();
        return this;
    }

    @Override
    public UsernamePasswordCredentialBuilder additionallyAllowedTenants(String ... additionallyAllowedTenants) {
        this.identityClientOptions.setAdditionallyAllowedTenants(IdentityUtil.resolveAdditionalTenants(Arrays.asList(additionallyAllowedTenants)));
        return this;
    }

    @Override
    public UsernamePasswordCredentialBuilder additionallyAllowedTenants(List<String> additionallyAllowedTenants) {
        this.identityClientOptions.setAdditionallyAllowedTenants(IdentityUtil.resolveAdditionalTenants(additionallyAllowedTenants));
        return this;
    }

    public UsernamePasswordCredential build() {
        ValidationUtil.validate(CLASS_NAME, LOGGER, "clientId", this.clientId, "username", this.username, "password", this.password);
        return new UsernamePasswordCredential(this.clientId, this.tenantId, this.username, this.password, this.identityClientOptions);
    }
}

