/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.identity;

import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.identity.CredentialBuilderBase;
import com.dataiku.dss.shadelibazure.com.azure.identity.VisualStudioCodeCredential;
import com.dataiku.dss.shadelibazure.com.azure.identity.implementation.util.IdentityUtil;
import com.dataiku.dss.shadelibazure.com.azure.identity.implementation.util.ValidationUtil;
import java.util.Arrays;
import java.util.List;

public class VisualStudioCodeCredentialBuilder
extends CredentialBuilderBase<VisualStudioCodeCredentialBuilder> {
    private static final ClientLogger LOGGER = new ClientLogger(VisualStudioCodeCredentialBuilder.class);
    private String tenantId;

    public VisualStudioCodeCredentialBuilder tenantId(String tenantId) {
        ValidationUtil.validateTenantIdCharacterRange(tenantId, LOGGER);
        this.tenantId = tenantId;
        return this;
    }

    public VisualStudioCodeCredentialBuilder additionallyAllowedTenants(String ... additionallyAllowedTenants) {
        this.identityClientOptions.setAdditionallyAllowedTenants(IdentityUtil.resolveAdditionalTenants(Arrays.asList(additionallyAllowedTenants)));
        return this;
    }

    public VisualStudioCodeCredentialBuilder additionallyAllowedTenants(List<String> additionallyAllowedTenants) {
        this.identityClientOptions.setAdditionallyAllowedTenants(IdentityUtil.resolveAdditionalTenants(additionallyAllowedTenants));
        return this;
    }

    public VisualStudioCodeCredential build() {
        return new VisualStudioCodeCredential(this.tenantId, this.identityClientOptions);
    }
}

