/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appplatform.implementation;

import com.dataiku.dss.shadelibazure.com.azure.core.annotation.BodyParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Delete;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ExpectedResponses;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Get;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.HeaderParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Headers;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Host;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.HostParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.PathParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Post;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Put;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.QueryParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ReturnType;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ServiceInterface;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ServiceMethod;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedFlux;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedIterable;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedResponse;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedResponseBase;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.Response;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.RestProxy;
import com.dataiku.dss.shadelibazure.com.azure.core.management.exception.ManagementException;
import com.dataiku.dss.shadelibazure.com.azure.core.management.polling.PollResult;
import com.dataiku.dss.shadelibazure.com.azure.core.util.Context;
import com.dataiku.dss.shadelibazure.com.azure.core.util.FluxUtil;
import com.dataiku.dss.shadelibazure.com.azure.core.util.polling.PollerFlux;
import com.dataiku.dss.shadelibazure.com.azure.core.util.polling.SyncPoller;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appplatform.fluent.ApmsClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appplatform.fluent.models.ApmResourceInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appplatform.fluent.models.ApmSecretKeysInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appplatform.implementation.AppPlatformManagementClientImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appplatform.models.ApmResourceCollection;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Flux;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;

public final class ApmsClientImpl
implements ApmsClient {
    private final ApmsService service;
    private final AppPlatformManagementClientImpl client;

    ApmsClientImpl(AppPlatformManagementClientImpl client) {
        this.service = RestProxy.create(ApmsService.class, client.getHttpPipeline(), client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ApmResourceInner>> listSinglePageAsync(String resourceGroupName, String serviceName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serviceName, "application/json", (Context)context)).map(res -> new PagedResponseBase<Object, ApmResourceInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ApmResourceCollection)res.getValue()).value(), ((ApmResourceCollection)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ApmResourceInner>> listSinglePageAsync(String resourceGroupName, String serviceName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.list(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serviceName, "application/json", context).map(res -> new PagedResponseBase<Object, ApmResourceInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ApmResourceCollection)res.getValue()).value(), ((ApmResourceCollection)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<ApmResourceInner> listAsync(String resourceGroupName, String serviceName) {
        return new PagedFlux<ApmResourceInner>(() -> this.listSinglePageAsync(resourceGroupName, serviceName), nextLink -> this.listNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<ApmResourceInner> listAsync(String resourceGroupName, String serviceName, Context context) {
        return new PagedFlux<ApmResourceInner>(() -> this.listSinglePageAsync(resourceGroupName, serviceName, context), nextLink -> this.listNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ApmResourceInner> list(String resourceGroupName, String serviceName) {
        return new PagedIterable<ApmResourceInner>(this.listAsync(resourceGroupName, serviceName));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ApmResourceInner> list(String resourceGroupName, String serviceName, Context context) {
        return new PagedIterable<ApmResourceInner>(this.listAsync(resourceGroupName, serviceName, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ApmResourceInner>> getWithResponseAsync(String resourceGroupName, String serviceName, String apmName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (apmName == null) {
            return Mono.error(new IllegalArgumentException("Parameter apmName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serviceName, apmName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<ApmResourceInner>> getWithResponseAsync(String resourceGroupName, String serviceName, String apmName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (apmName == null) {
            return Mono.error(new IllegalArgumentException("Parameter apmName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serviceName, apmName, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ApmResourceInner> getAsync(String resourceGroupName, String serviceName, String apmName) {
        return this.getWithResponseAsync(resourceGroupName, serviceName, apmName).flatMap(res -> Mono.justOrEmpty((ApmResourceInner)res.getValue()));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ApmResourceInner> getWithResponse(String resourceGroupName, String serviceName, String apmName, Context context) {
        return this.getWithResponseAsync(resourceGroupName, serviceName, apmName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ApmResourceInner get(String resourceGroupName, String serviceName, String apmName) {
        return this.getWithResponse(resourceGroupName, serviceName, apmName, Context.NONE).getValue();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String serviceName, String apmName, ApmResourceInner apmResource) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (apmName == null) {
            return Mono.error(new IllegalArgumentException("Parameter apmName is required and cannot be null."));
        }
        if (apmResource == null) {
            return Mono.error(new IllegalArgumentException("Parameter apmResource is required and cannot be null."));
        }
        apmResource.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serviceName, apmName, apmResource, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String serviceName, String apmName, ApmResourceInner apmResource, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (apmName == null) {
            return Mono.error(new IllegalArgumentException("Parameter apmName is required and cannot be null."));
        }
        if (apmResource == null) {
            return Mono.error(new IllegalArgumentException("Parameter apmResource is required and cannot be null."));
        }
        apmResource.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createOrUpdate(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serviceName, apmName, apmResource, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<ApmResourceInner>, ApmResourceInner> beginCreateOrUpdateAsync(String resourceGroupName, String serviceName, String apmName, ApmResourceInner apmResource) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, serviceName, apmName, apmResource);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)ApmResourceInner.class), (Type)((Object)ApmResourceInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<ApmResourceInner>, ApmResourceInner> beginCreateOrUpdateAsync(String resourceGroupName, String serviceName, String apmName, ApmResourceInner apmResource, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, serviceName, apmName, apmResource, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)ApmResourceInner.class), (Type)((Object)ApmResourceInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<ApmResourceInner>, ApmResourceInner> beginCreateOrUpdate(String resourceGroupName, String serviceName, String apmName, ApmResourceInner apmResource) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, serviceName, apmName, apmResource).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<ApmResourceInner>, ApmResourceInner> beginCreateOrUpdate(String resourceGroupName, String serviceName, String apmName, ApmResourceInner apmResource, Context context) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, serviceName, apmName, apmResource, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ApmResourceInner> createOrUpdateAsync(String resourceGroupName, String serviceName, String apmName, ApmResourceInner apmResource) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, serviceName, apmName, apmResource).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<ApmResourceInner> createOrUpdateAsync(String resourceGroupName, String serviceName, String apmName, ApmResourceInner apmResource, Context context) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, serviceName, apmName, apmResource, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ApmResourceInner createOrUpdate(String resourceGroupName, String serviceName, String apmName, ApmResourceInner apmResource) {
        return this.createOrUpdateAsync(resourceGroupName, serviceName, apmName, apmResource).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ApmResourceInner createOrUpdate(String resourceGroupName, String serviceName, String apmName, ApmResourceInner apmResource, Context context) {
        return this.createOrUpdateAsync(resourceGroupName, serviceName, apmName, apmResource, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String serviceName, String apmName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (apmName == null) {
            return Mono.error(new IllegalArgumentException("Parameter apmName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serviceName, apmName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String serviceName, String apmName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (apmName == null) {
            return Mono.error(new IllegalArgumentException("Parameter apmName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serviceName, apmName, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String serviceName, String apmName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, serviceName, apmName);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String serviceName, String apmName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, serviceName, apmName, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String serviceName, String apmName) {
        return this.beginDeleteAsync(resourceGroupName, serviceName, apmName).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String serviceName, String apmName, Context context) {
        return this.beginDeleteAsync(resourceGroupName, serviceName, apmName, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String resourceGroupName, String serviceName, String apmName) {
        return this.beginDeleteAsync(resourceGroupName, serviceName, apmName).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String serviceName, String apmName, Context context) {
        return this.beginDeleteAsync(resourceGroupName, serviceName, apmName, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String serviceName, String apmName) {
        this.deleteAsync(resourceGroupName, serviceName, apmName).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String serviceName, String apmName, Context context) {
        this.deleteAsync(resourceGroupName, serviceName, apmName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ApmSecretKeysInner>> listSecretKeysWithResponseAsync(String resourceGroupName, String serviceName, String apmName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (apmName == null) {
            return Mono.error(new IllegalArgumentException("Parameter apmName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listSecretKeys(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serviceName, apmName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<ApmSecretKeysInner>> listSecretKeysWithResponseAsync(String resourceGroupName, String serviceName, String apmName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (apmName == null) {
            return Mono.error(new IllegalArgumentException("Parameter apmName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listSecretKeys(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serviceName, apmName, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ApmSecretKeysInner> listSecretKeysAsync(String resourceGroupName, String serviceName, String apmName) {
        return this.listSecretKeysWithResponseAsync(resourceGroupName, serviceName, apmName).flatMap(res -> Mono.justOrEmpty((ApmSecretKeysInner)res.getValue()));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ApmSecretKeysInner> listSecretKeysWithResponse(String resourceGroupName, String serviceName, String apmName, Context context) {
        return this.listSecretKeysWithResponseAsync(resourceGroupName, serviceName, apmName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ApmSecretKeysInner listSecretKeys(String resourceGroupName, String serviceName, String apmName) {
        return this.listSecretKeysWithResponse(resourceGroupName, serviceName, apmName, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ApmResourceInner>> listNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase<Object, ApmResourceInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ApmResourceCollection)res.getValue()).value(), ((ApmResourceCollection)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ApmResourceInner>> listNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase<Object, ApmResourceInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ApmResourceCollection)res.getValue()).value(), ((ApmResourceCollection)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="AppPlatformManagemen")
    public static interface ApmsService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/apms")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ApmResourceCollection>> list(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="serviceName") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/apms/{apmName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ApmResourceInner>> get(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="serviceName") String var5, @PathParam(value="apmName") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/apms/{apmName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> createOrUpdate(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="serviceName") String var5, @PathParam(value="apmName") String var6, @BodyParam(value="application/json") ApmResourceInner var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/apms/{apmName}")
        @ExpectedResponses(value={202, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> delete(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="serviceName") String var5, @PathParam(value="apmName") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/apms/{apmName}/listSecretKeys")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ApmSecretKeysInner>> listSecretKeys(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="serviceName") String var5, @PathParam(value="apmName") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ApmResourceCollection>> listNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

