/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appplatform.models;

import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appplatform.models.MarketplaceResource;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appplatform.models.NetworkProfile;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appplatform.models.PowerState;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appplatform.models.ProvisioningState;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appplatform.models.ServiceVNetAddons;
import java.io.IOException;

public final class ClusterResourceProperties
implements JsonSerializable<ClusterResourceProperties> {
    private ProvisioningState provisioningState;
    private NetworkProfile networkProfile;
    private ServiceVNetAddons vnetAddons;
    private Integer version;
    private String serviceId;
    private PowerState powerState;
    private Boolean zoneRedundant;
    private String fqdn;
    private MarketplaceResource marketplaceResource;

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public NetworkProfile networkProfile() {
        return this.networkProfile;
    }

    public ClusterResourceProperties withNetworkProfile(NetworkProfile networkProfile) {
        this.networkProfile = networkProfile;
        return this;
    }

    public ServiceVNetAddons vnetAddons() {
        return this.vnetAddons;
    }

    public ClusterResourceProperties withVnetAddons(ServiceVNetAddons vnetAddons) {
        this.vnetAddons = vnetAddons;
        return this;
    }

    public Integer version() {
        return this.version;
    }

    public String serviceId() {
        return this.serviceId;
    }

    public PowerState powerState() {
        return this.powerState;
    }

    public Boolean zoneRedundant() {
        return this.zoneRedundant;
    }

    public ClusterResourceProperties withZoneRedundant(Boolean zoneRedundant) {
        this.zoneRedundant = zoneRedundant;
        return this;
    }

    public String fqdn() {
        return this.fqdn;
    }

    public MarketplaceResource marketplaceResource() {
        return this.marketplaceResource;
    }

    public ClusterResourceProperties withMarketplaceResource(MarketplaceResource marketplaceResource) {
        this.marketplaceResource = marketplaceResource;
        return this;
    }

    public void validate() {
        if (this.networkProfile() != null) {
            this.networkProfile().validate();
        }
        if (this.vnetAddons() != null) {
            this.vnetAddons().validate();
        }
        if (this.marketplaceResource() != null) {
            this.marketplaceResource().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("networkProfile", this.networkProfile);
        jsonWriter.writeJsonField("vnetAddons", this.vnetAddons);
        jsonWriter.writeBooleanField("zoneRedundant", this.zoneRedundant);
        jsonWriter.writeJsonField("marketplaceResource", this.marketplaceResource);
        return jsonWriter.writeEndObject();
    }

    public static ClusterResourceProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ClusterResourceProperties deserializedClusterResourceProperties = new ClusterResourceProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("provisioningState".equals(fieldName)) {
                    deserializedClusterResourceProperties.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("networkProfile".equals(fieldName)) {
                    deserializedClusterResourceProperties.networkProfile = NetworkProfile.fromJson(reader);
                    continue;
                }
                if ("vnetAddons".equals(fieldName)) {
                    deserializedClusterResourceProperties.vnetAddons = ServiceVNetAddons.fromJson(reader);
                    continue;
                }
                if ("version".equals(fieldName)) {
                    deserializedClusterResourceProperties.version = reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("serviceId".equals(fieldName)) {
                    deserializedClusterResourceProperties.serviceId = reader.getString();
                    continue;
                }
                if ("powerState".equals(fieldName)) {
                    deserializedClusterResourceProperties.powerState = PowerState.fromString(reader.getString());
                    continue;
                }
                if ("zoneRedundant".equals(fieldName)) {
                    deserializedClusterResourceProperties.zoneRedundant = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("fqdn".equals(fieldName)) {
                    deserializedClusterResourceProperties.fqdn = reader.getString();
                    continue;
                }
                if ("marketplaceResource".equals(fieldName)) {
                    deserializedClusterResourceProperties.marketplaceResource = MarketplaceResource.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedClusterResourceProperties;
        });
    }
}

