/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appplatform.models;

import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appplatform.models.ApmReference;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appplatform.models.GatewayApiMetadataProperties;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appplatform.models.GatewayCorsProperties;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appplatform.models.GatewayInstance;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appplatform.models.GatewayOperatorProperties;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appplatform.models.GatewayPropertiesClientAuth;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appplatform.models.GatewayPropertiesEnvironmentVariables;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appplatform.models.GatewayProvisioningState;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appplatform.models.GatewayResourceRequests;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appplatform.models.SsoProperties;
import java.io.IOException;
import java.util.List;

public final class GatewayProperties
implements JsonSerializable<GatewayProperties> {
    private GatewayProvisioningState provisioningState;
    private Boolean publicProperty;
    private String url;
    private Boolean httpsOnly;
    private SsoProperties ssoProperties;
    private GatewayApiMetadataProperties apiMetadataProperties;
    private GatewayCorsProperties corsProperties;
    private GatewayPropertiesClientAuth clientAuth;
    private List<ApmReference> apms;
    private GatewayPropertiesEnvironmentVariables environmentVariables;
    private GatewayResourceRequests resourceRequests;
    private List<GatewayInstance> instances;
    private GatewayOperatorProperties operatorProperties;

    public GatewayProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public Boolean publicProperty() {
        return this.publicProperty;
    }

    public GatewayProperties withPublicProperty(Boolean publicProperty) {
        this.publicProperty = publicProperty;
        return this;
    }

    public String url() {
        return this.url;
    }

    public Boolean httpsOnly() {
        return this.httpsOnly;
    }

    public GatewayProperties withHttpsOnly(Boolean httpsOnly) {
        this.httpsOnly = httpsOnly;
        return this;
    }

    public SsoProperties ssoProperties() {
        return this.ssoProperties;
    }

    public GatewayProperties withSsoProperties(SsoProperties ssoProperties) {
        this.ssoProperties = ssoProperties;
        return this;
    }

    public GatewayApiMetadataProperties apiMetadataProperties() {
        return this.apiMetadataProperties;
    }

    public GatewayProperties withApiMetadataProperties(GatewayApiMetadataProperties apiMetadataProperties) {
        this.apiMetadataProperties = apiMetadataProperties;
        return this;
    }

    public GatewayCorsProperties corsProperties() {
        return this.corsProperties;
    }

    public GatewayProperties withCorsProperties(GatewayCorsProperties corsProperties) {
        this.corsProperties = corsProperties;
        return this;
    }

    public GatewayPropertiesClientAuth clientAuth() {
        return this.clientAuth;
    }

    public GatewayProperties withClientAuth(GatewayPropertiesClientAuth clientAuth) {
        this.clientAuth = clientAuth;
        return this;
    }

    public List<ApmReference> apms() {
        return this.apms;
    }

    public GatewayProperties withApms(List<ApmReference> apms) {
        this.apms = apms;
        return this;
    }

    public GatewayPropertiesEnvironmentVariables environmentVariables() {
        return this.environmentVariables;
    }

    public GatewayProperties withEnvironmentVariables(GatewayPropertiesEnvironmentVariables environmentVariables) {
        this.environmentVariables = environmentVariables;
        return this;
    }

    public GatewayResourceRequests resourceRequests() {
        return this.resourceRequests;
    }

    public GatewayProperties withResourceRequests(GatewayResourceRequests resourceRequests) {
        this.resourceRequests = resourceRequests;
        return this;
    }

    public List<GatewayInstance> instances() {
        return this.instances;
    }

    public GatewayOperatorProperties operatorProperties() {
        return this.operatorProperties;
    }

    public void validate() {
        if (this.ssoProperties() != null) {
            this.ssoProperties().validate();
        }
        if (this.apiMetadataProperties() != null) {
            this.apiMetadataProperties().validate();
        }
        if (this.corsProperties() != null) {
            this.corsProperties().validate();
        }
        if (this.clientAuth() != null) {
            this.clientAuth().validate();
        }
        if (this.apms() != null) {
            this.apms().forEach(e -> e.validate());
        }
        if (this.environmentVariables() != null) {
            this.environmentVariables().validate();
        }
        if (this.resourceRequests() != null) {
            this.resourceRequests().validate();
        }
        if (this.instances() != null) {
            this.instances().forEach(e -> e.validate());
        }
        if (this.operatorProperties() != null) {
            this.operatorProperties().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("public", this.publicProperty);
        jsonWriter.writeBooleanField("httpsOnly", this.httpsOnly);
        jsonWriter.writeJsonField("ssoProperties", this.ssoProperties);
        jsonWriter.writeJsonField("apiMetadataProperties", this.apiMetadataProperties);
        jsonWriter.writeJsonField("corsProperties", this.corsProperties);
        jsonWriter.writeJsonField("clientAuth", this.clientAuth);
        jsonWriter.writeArrayField("apms", this.apms, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        jsonWriter.writeJsonField("environmentVariables", this.environmentVariables);
        jsonWriter.writeJsonField("resourceRequests", this.resourceRequests);
        return jsonWriter.writeEndObject();
    }

    public static GatewayProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            GatewayProperties deserializedGatewayProperties = new GatewayProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("provisioningState".equals(fieldName)) {
                    deserializedGatewayProperties.provisioningState = GatewayProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("public".equals(fieldName)) {
                    deserializedGatewayProperties.publicProperty = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("url".equals(fieldName)) {
                    deserializedGatewayProperties.url = reader.getString();
                    continue;
                }
                if ("httpsOnly".equals(fieldName)) {
                    deserializedGatewayProperties.httpsOnly = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("ssoProperties".equals(fieldName)) {
                    deserializedGatewayProperties.ssoProperties = SsoProperties.fromJson(reader);
                    continue;
                }
                if ("apiMetadataProperties".equals(fieldName)) {
                    deserializedGatewayProperties.apiMetadataProperties = GatewayApiMetadataProperties.fromJson(reader);
                    continue;
                }
                if ("corsProperties".equals(fieldName)) {
                    deserializedGatewayProperties.corsProperties = GatewayCorsProperties.fromJson(reader);
                    continue;
                }
                if ("clientAuth".equals(fieldName)) {
                    deserializedGatewayProperties.clientAuth = GatewayPropertiesClientAuth.fromJson(reader);
                    continue;
                }
                if ("apms".equals(fieldName)) {
                    List<ApmReference> apms = reader.readArray(reader1 -> ApmReference.fromJson(reader1));
                    deserializedGatewayProperties.apms = apms;
                    continue;
                }
                if ("environmentVariables".equals(fieldName)) {
                    deserializedGatewayProperties.environmentVariables = GatewayPropertiesEnvironmentVariables.fromJson(reader);
                    continue;
                }
                if ("resourceRequests".equals(fieldName)) {
                    deserializedGatewayProperties.resourceRequests = GatewayResourceRequests.fromJson(reader);
                    continue;
                }
                if ("instances".equals(fieldName)) {
                    List<GatewayInstance> instances = reader.readArray(reader1 -> GatewayInstance.fromJson(reader1));
                    deserializedGatewayProperties.instances = instances;
                    continue;
                }
                if ("operatorProperties".equals(fieldName)) {
                    deserializedGatewayProperties.operatorProperties = GatewayOperatorProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedGatewayProperties;
        });
    }
}

