/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.fluent.models;

import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.DataProviderMetadata;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.DetectorInfo;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.DiagnosticData;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.QueryUtterancesResults;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.Status;
import java.io.IOException;
import java.util.List;

public final class DetectorResponseProperties
implements JsonSerializable<DetectorResponseProperties> {
    private DetectorInfo metadata;
    private List<DiagnosticData> dataset;
    private Status status;
    private List<DataProviderMetadata> dataProvidersMetadata;
    private QueryUtterancesResults suggestedUtterances;

    public DetectorInfo metadata() {
        return this.metadata;
    }

    public DetectorResponseProperties withMetadata(DetectorInfo metadata) {
        this.metadata = metadata;
        return this;
    }

    public List<DiagnosticData> dataset() {
        return this.dataset;
    }

    public DetectorResponseProperties withDataset(List<DiagnosticData> dataset) {
        this.dataset = dataset;
        return this;
    }

    public Status status() {
        return this.status;
    }

    public DetectorResponseProperties withStatus(Status status) {
        this.status = status;
        return this;
    }

    public List<DataProviderMetadata> dataProvidersMetadata() {
        return this.dataProvidersMetadata;
    }

    public DetectorResponseProperties withDataProvidersMetadata(List<DataProviderMetadata> dataProvidersMetadata) {
        this.dataProvidersMetadata = dataProvidersMetadata;
        return this;
    }

    public QueryUtterancesResults suggestedUtterances() {
        return this.suggestedUtterances;
    }

    public DetectorResponseProperties withSuggestedUtterances(QueryUtterancesResults suggestedUtterances) {
        this.suggestedUtterances = suggestedUtterances;
        return this;
    }

    public void validate() {
        if (this.metadata() != null) {
            this.metadata().validate();
        }
        if (this.dataset() != null) {
            this.dataset().forEach(e -> e.validate());
        }
        if (this.status() != null) {
            this.status().validate();
        }
        if (this.dataProvidersMetadata() != null) {
            this.dataProvidersMetadata().forEach(e -> e.validate());
        }
        if (this.suggestedUtterances() != null) {
            this.suggestedUtterances().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("metadata", this.metadata);
        jsonWriter.writeArrayField("dataset", this.dataset, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        jsonWriter.writeJsonField("status", this.status);
        jsonWriter.writeArrayField("dataProvidersMetadata", this.dataProvidersMetadata, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        jsonWriter.writeJsonField("suggestedUtterances", this.suggestedUtterances);
        return jsonWriter.writeEndObject();
    }

    public static DetectorResponseProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DetectorResponseProperties deserializedDetectorResponseProperties = new DetectorResponseProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("metadata".equals(fieldName)) {
                    deserializedDetectorResponseProperties.metadata = DetectorInfo.fromJson(reader);
                    continue;
                }
                if ("dataset".equals(fieldName)) {
                    List<DiagnosticData> dataset = reader.readArray(reader1 -> DiagnosticData.fromJson(reader1));
                    deserializedDetectorResponseProperties.dataset = dataset;
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedDetectorResponseProperties.status = Status.fromJson(reader);
                    continue;
                }
                if ("dataProvidersMetadata".equals(fieldName)) {
                    List<DataProviderMetadata> dataProvidersMetadata = reader.readArray(reader1 -> DataProviderMetadata.fromJson(reader1));
                    deserializedDetectorResponseProperties.dataProvidersMetadata = dataProvidersMetadata;
                    continue;
                }
                if ("suggestedUtterances".equals(fieldName)) {
                    deserializedDetectorResponseProperties.suggestedUtterances = QueryUtterancesResults.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDetectorResponseProperties;
        });
    }
}

