/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.fluent.models;

import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.MSDeployCore;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class MSDeployProperties
extends MSDeployCore {
    private List<MSDeployCore> addOnPackages;

    public List<MSDeployCore> addOnPackages() {
        return this.addOnPackages;
    }

    public MSDeployProperties withAddOnPackages(List<MSDeployCore> addOnPackages) {
        this.addOnPackages = addOnPackages;
        return this;
    }

    @Override
    public MSDeployProperties withPackageUri(String packageUri) {
        super.withPackageUri(packageUri);
        return this;
    }

    @Override
    public MSDeployProperties withConnectionString(String connectionString) {
        super.withConnectionString(connectionString);
        return this;
    }

    @Override
    public MSDeployProperties withDbType(String dbType) {
        super.withDbType(dbType);
        return this;
    }

    @Override
    public MSDeployProperties withSetParametersXmlFileUri(String setParametersXmlFileUri) {
        super.withSetParametersXmlFileUri(setParametersXmlFileUri);
        return this;
    }

    @Override
    public MSDeployProperties withSetParameters(Map<String, String> setParameters) {
        super.withSetParameters(setParameters);
        return this;
    }

    @Override
    public MSDeployProperties withSkipAppData(Boolean skipAppData) {
        super.withSkipAppData(skipAppData);
        return this;
    }

    @Override
    public MSDeployProperties withAppOffline(Boolean appOffline) {
        super.withAppOffline(appOffline);
        return this;
    }

    @Override
    public void validate() {
        if (this.addOnPackages() != null) {
            this.addOnPackages().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("packageUri", this.packageUri());
        jsonWriter.writeStringField("connectionString", this.connectionString());
        jsonWriter.writeStringField("dbType", this.dbType());
        jsonWriter.writeStringField("setParametersXmlFileUri", this.setParametersXmlFileUri());
        jsonWriter.writeMapField("setParameters", this.setParameters(), (writer, element) -> writer.writeString((String)element));
        jsonWriter.writeBooleanField("skipAppData", this.skipAppData());
        jsonWriter.writeBooleanField("appOffline", this.appOffline());
        jsonWriter.writeArrayField("addOnPackages", this.addOnPackages, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        return jsonWriter.writeEndObject();
    }

    public static MSDeployProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MSDeployProperties deserializedMSDeployProperties = new MSDeployProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("packageUri".equals(fieldName)) {
                    deserializedMSDeployProperties.withPackageUri(reader.getString());
                    continue;
                }
                if ("connectionString".equals(fieldName)) {
                    deserializedMSDeployProperties.withConnectionString(reader.getString());
                    continue;
                }
                if ("dbType".equals(fieldName)) {
                    deserializedMSDeployProperties.withDbType(reader.getString());
                    continue;
                }
                if ("setParametersXmlFileUri".equals(fieldName)) {
                    deserializedMSDeployProperties.withSetParametersXmlFileUri(reader.getString());
                    continue;
                }
                if ("setParameters".equals(fieldName)) {
                    Map<String, String> setParameters = reader.readMap(reader1 -> reader1.getString());
                    deserializedMSDeployProperties.withSetParameters((Map)setParameters);
                    continue;
                }
                if ("skipAppData".equals(fieldName)) {
                    deserializedMSDeployProperties.withSkipAppData(reader.getNullable(JsonReader::getBoolean));
                    continue;
                }
                if ("appOffline".equals(fieldName)) {
                    deserializedMSDeployProperties.withAppOffline(reader.getNullable(JsonReader::getBoolean));
                    continue;
                }
                if ("addOnPackages".equals(fieldName)) {
                    List<MSDeployCore> addOnPackages = reader.readArray(reader1 -> MSDeployCore.fromJson(reader1));
                    deserializedMSDeployProperties.addOnPackages = addOnPackages;
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMSDeployProperties;
        });
    }
}

