/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.fluent.models;

import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.DatabaseConnectionOverview;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.EnterpriseGradeCdnStatus;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.ResponseMessageEnvelopeRemotePrivateEndpointConnection;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.StagingEnvironmentPolicy;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.StaticSiteBuildProperties;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.StaticSiteLinkedBackend;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.StaticSiteTemplateOptions;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.StaticSiteUserProvidedFunctionApp;
import java.io.IOException;
import java.util.List;

public final class StaticSite
implements JsonSerializable<StaticSite> {
    private String defaultHostname;
    private String repositoryUrl;
    private String branch;
    private List<String> customDomains;
    private String repositoryToken;
    private StaticSiteBuildProperties buildProperties;
    private List<ResponseMessageEnvelopeRemotePrivateEndpointConnection> privateEndpointConnections;
    private StagingEnvironmentPolicy stagingEnvironmentPolicy;
    private Boolean allowConfigFileUpdates;
    private StaticSiteTemplateOptions templateProperties;
    private String contentDistributionEndpoint;
    private String keyVaultReferenceIdentity;
    private List<StaticSiteUserProvidedFunctionApp> userProvidedFunctionApps;
    private List<StaticSiteLinkedBackend> linkedBackends;
    private String provider;
    private EnterpriseGradeCdnStatus enterpriseGradeCdnStatus;
    private String publicNetworkAccess;
    private List<DatabaseConnectionOverview> databaseConnections;

    public String defaultHostname() {
        return this.defaultHostname;
    }

    public String repositoryUrl() {
        return this.repositoryUrl;
    }

    public StaticSite withRepositoryUrl(String repositoryUrl) {
        this.repositoryUrl = repositoryUrl;
        return this;
    }

    public String branch() {
        return this.branch;
    }

    public StaticSite withBranch(String branch) {
        this.branch = branch;
        return this;
    }

    public List<String> customDomains() {
        return this.customDomains;
    }

    public String repositoryToken() {
        return this.repositoryToken;
    }

    public StaticSite withRepositoryToken(String repositoryToken) {
        this.repositoryToken = repositoryToken;
        return this;
    }

    public StaticSiteBuildProperties buildProperties() {
        return this.buildProperties;
    }

    public StaticSite withBuildProperties(StaticSiteBuildProperties buildProperties) {
        this.buildProperties = buildProperties;
        return this;
    }

    public List<ResponseMessageEnvelopeRemotePrivateEndpointConnection> privateEndpointConnections() {
        return this.privateEndpointConnections;
    }

    public StagingEnvironmentPolicy stagingEnvironmentPolicy() {
        return this.stagingEnvironmentPolicy;
    }

    public StaticSite withStagingEnvironmentPolicy(StagingEnvironmentPolicy stagingEnvironmentPolicy) {
        this.stagingEnvironmentPolicy = stagingEnvironmentPolicy;
        return this;
    }

    public Boolean allowConfigFileUpdates() {
        return this.allowConfigFileUpdates;
    }

    public StaticSite withAllowConfigFileUpdates(Boolean allowConfigFileUpdates) {
        this.allowConfigFileUpdates = allowConfigFileUpdates;
        return this;
    }

    public StaticSiteTemplateOptions templateProperties() {
        return this.templateProperties;
    }

    public StaticSite withTemplateProperties(StaticSiteTemplateOptions templateProperties) {
        this.templateProperties = templateProperties;
        return this;
    }

    public String contentDistributionEndpoint() {
        return this.contentDistributionEndpoint;
    }

    public String keyVaultReferenceIdentity() {
        return this.keyVaultReferenceIdentity;
    }

    public List<StaticSiteUserProvidedFunctionApp> userProvidedFunctionApps() {
        return this.userProvidedFunctionApps;
    }

    public List<StaticSiteLinkedBackend> linkedBackends() {
        return this.linkedBackends;
    }

    public String provider() {
        return this.provider;
    }

    public StaticSite withProvider(String provider) {
        this.provider = provider;
        return this;
    }

    public EnterpriseGradeCdnStatus enterpriseGradeCdnStatus() {
        return this.enterpriseGradeCdnStatus;
    }

    public StaticSite withEnterpriseGradeCdnStatus(EnterpriseGradeCdnStatus enterpriseGradeCdnStatus) {
        this.enterpriseGradeCdnStatus = enterpriseGradeCdnStatus;
        return this;
    }

    public String publicNetworkAccess() {
        return this.publicNetworkAccess;
    }

    public StaticSite withPublicNetworkAccess(String publicNetworkAccess) {
        this.publicNetworkAccess = publicNetworkAccess;
        return this;
    }

    public List<DatabaseConnectionOverview> databaseConnections() {
        return this.databaseConnections;
    }

    public void validate() {
        if (this.buildProperties() != null) {
            this.buildProperties().validate();
        }
        if (this.privateEndpointConnections() != null) {
            this.privateEndpointConnections().forEach(e -> e.validate());
        }
        if (this.templateProperties() != null) {
            this.templateProperties().validate();
        }
        if (this.userProvidedFunctionApps() != null) {
            this.userProvidedFunctionApps().forEach(e -> e.validate());
        }
        if (this.linkedBackends() != null) {
            this.linkedBackends().forEach(e -> e.validate());
        }
        if (this.databaseConnections() != null) {
            this.databaseConnections().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("repositoryUrl", this.repositoryUrl);
        jsonWriter.writeStringField("branch", this.branch);
        jsonWriter.writeStringField("repositoryToken", this.repositoryToken);
        jsonWriter.writeJsonField("buildProperties", this.buildProperties);
        jsonWriter.writeStringField("stagingEnvironmentPolicy", this.stagingEnvironmentPolicy == null ? null : this.stagingEnvironmentPolicy.toString());
        jsonWriter.writeBooleanField("allowConfigFileUpdates", this.allowConfigFileUpdates);
        jsonWriter.writeJsonField("templateProperties", this.templateProperties);
        jsonWriter.writeStringField("provider", this.provider);
        jsonWriter.writeStringField("enterpriseGradeCdnStatus", this.enterpriseGradeCdnStatus == null ? null : this.enterpriseGradeCdnStatus.toString());
        jsonWriter.writeStringField("publicNetworkAccess", this.publicNetworkAccess);
        return jsonWriter.writeEndObject();
    }

    public static StaticSite fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            StaticSite deserializedStaticSite = new StaticSite();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("defaultHostname".equals(fieldName)) {
                    deserializedStaticSite.defaultHostname = reader.getString();
                    continue;
                }
                if ("repositoryUrl".equals(fieldName)) {
                    deserializedStaticSite.repositoryUrl = reader.getString();
                    continue;
                }
                if ("branch".equals(fieldName)) {
                    deserializedStaticSite.branch = reader.getString();
                    continue;
                }
                if ("customDomains".equals(fieldName)) {
                    List<String> customDomains = reader.readArray(reader1 -> reader1.getString());
                    deserializedStaticSite.customDomains = customDomains;
                    continue;
                }
                if ("repositoryToken".equals(fieldName)) {
                    deserializedStaticSite.repositoryToken = reader.getString();
                    continue;
                }
                if ("buildProperties".equals(fieldName)) {
                    deserializedStaticSite.buildProperties = StaticSiteBuildProperties.fromJson(reader);
                    continue;
                }
                if ("privateEndpointConnections".equals(fieldName)) {
                    List<ResponseMessageEnvelopeRemotePrivateEndpointConnection> privateEndpointConnections = reader.readArray(reader1 -> ResponseMessageEnvelopeRemotePrivateEndpointConnection.fromJson(reader1));
                    deserializedStaticSite.privateEndpointConnections = privateEndpointConnections;
                    continue;
                }
                if ("stagingEnvironmentPolicy".equals(fieldName)) {
                    deserializedStaticSite.stagingEnvironmentPolicy = StagingEnvironmentPolicy.fromString(reader.getString());
                    continue;
                }
                if ("allowConfigFileUpdates".equals(fieldName)) {
                    deserializedStaticSite.allowConfigFileUpdates = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("templateProperties".equals(fieldName)) {
                    deserializedStaticSite.templateProperties = StaticSiteTemplateOptions.fromJson(reader);
                    continue;
                }
                if ("contentDistributionEndpoint".equals(fieldName)) {
                    deserializedStaticSite.contentDistributionEndpoint = reader.getString();
                    continue;
                }
                if ("keyVaultReferenceIdentity".equals(fieldName)) {
                    deserializedStaticSite.keyVaultReferenceIdentity = reader.getString();
                    continue;
                }
                if ("userProvidedFunctionApps".equals(fieldName)) {
                    List<StaticSiteUserProvidedFunctionApp> userProvidedFunctionApps = reader.readArray(reader1 -> StaticSiteUserProvidedFunctionApp.fromJson(reader1));
                    deserializedStaticSite.userProvidedFunctionApps = userProvidedFunctionApps;
                    continue;
                }
                if ("linkedBackends".equals(fieldName)) {
                    List<StaticSiteLinkedBackend> linkedBackends = reader.readArray(reader1 -> StaticSiteLinkedBackend.fromJson(reader1));
                    deserializedStaticSite.linkedBackends = linkedBackends;
                    continue;
                }
                if ("provider".equals(fieldName)) {
                    deserializedStaticSite.provider = reader.getString();
                    continue;
                }
                if ("enterpriseGradeCdnStatus".equals(fieldName)) {
                    deserializedStaticSite.enterpriseGradeCdnStatus = EnterpriseGradeCdnStatus.fromString(reader.getString());
                    continue;
                }
                if ("publicNetworkAccess".equals(fieldName)) {
                    deserializedStaticSite.publicNetworkAccess = reader.getString();
                    continue;
                }
                if ("databaseConnections".equals(fieldName)) {
                    List<DatabaseConnectionOverview> databaseConnections = reader.readArray(reader1 -> DatabaseConnectionOverview.fromJson(reader1));
                    deserializedStaticSite.databaseConnections = databaseConnections;
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedStaticSite;
        });
    }
}

