/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.fluent.models;

import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.StackPreferredOs;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.WebAppMajorVersion;
import java.io.IOException;
import java.util.List;

public final class WebAppStackProperties
implements JsonSerializable<WebAppStackProperties> {
    private String displayText;
    private String value;
    private List<WebAppMajorVersion> majorVersions;
    private StackPreferredOs preferredOs;

    public String displayText() {
        return this.displayText;
    }

    public String value() {
        return this.value;
    }

    public List<WebAppMajorVersion> majorVersions() {
        return this.majorVersions;
    }

    public StackPreferredOs preferredOs() {
        return this.preferredOs;
    }

    public void validate() {
        if (this.majorVersions() != null) {
            this.majorVersions().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    public static WebAppStackProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            WebAppStackProperties deserializedWebAppStackProperties = new WebAppStackProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("displayText".equals(fieldName)) {
                    deserializedWebAppStackProperties.displayText = reader.getString();
                    continue;
                }
                if ("value".equals(fieldName)) {
                    deserializedWebAppStackProperties.value = reader.getString();
                    continue;
                }
                if ("majorVersions".equals(fieldName)) {
                    List<WebAppMajorVersion> majorVersions = reader.readArray(reader1 -> WebAppMajorVersion.fromJson(reader1));
                    deserializedWebAppStackProperties.majorVersions = majorVersions;
                    continue;
                }
                if ("preferredOs".equals(fieldName)) {
                    deserializedWebAppStackProperties.preferredOs = StackPreferredOs.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedWebAppStackProperties;
        });
    }
}

