/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.implementation;

import com.dataiku.dss.shadelibazure.com.azure.core.management.Region;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.AppServiceManager;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.fluent.WebSiteManagementClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.fluent.models.AppServiceCertificateOrderInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.fluent.models.AppServiceCertificateResourceInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.implementation.AppServiceCertificateKeyVaultBindingImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.AppServiceCertificateKeyVaultBinding;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.AppServiceCertificateOrder;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.AppServiceDomain;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.CertificateDetails;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.CertificateOrderStatus;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.CertificateProductType;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.WebAppBase;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.keyvault.models.SecretPermissions;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.keyvault.models.Vault;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.models.implementation.GroupableResourceImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.utils.ResourceManagerUtils;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import java.time.OffsetDateTime;

class AppServiceCertificateOrderImpl
extends GroupableResourceImpl<AppServiceCertificateOrder, AppServiceCertificateOrderInner, AppServiceCertificateOrderImpl, AppServiceManager>
implements AppServiceCertificateOrder,
AppServiceCertificateOrder.Definition,
AppServiceCertificateOrder.Update {
    private WebAppBase domainVerifyWebApp;
    private AppServiceDomain domainVerifyDomain;
    private Mono<Vault> bindingVault;

    AppServiceCertificateOrderImpl(String key, AppServiceCertificateOrderInner innerObject, AppServiceManager manager) {
        super(key, innerObject, manager);
        ((AppServiceCertificateOrderImpl)this.withRegion("global")).withValidYears(1);
    }

    @Override
    protected Mono<AppServiceCertificateOrderInner> getInnerAsync() {
        return ((WebSiteManagementClient)((AppServiceManager)this.manager()).serviceClient()).getAppServiceCertificateOrders().getByResourceGroupAsync(this.resourceGroupName(), this.name());
    }

    @Override
    public AppServiceCertificateKeyVaultBinding getKeyVaultBinding() {
        return this.getKeyVaultBindingAsync().block();
    }

    @Override
    public Mono<AppServiceCertificateKeyVaultBinding> getKeyVaultBindingAsync() {
        return ((WebSiteManagementClient)((AppServiceManager)this.manager()).serviceClient()).getAppServiceCertificateOrders().listCertificatesAsync(this.resourceGroupName(), this.name()).switchIfEmpty(Mono.empty()).take(1L).singleOrEmpty().map(inner -> new AppServiceCertificateKeyVaultBindingImpl((AppServiceCertificateResourceInner)inner, this));
    }

    @Override
    public void verifyDomainOwnership(AppServiceDomain domain) {
        this.verifyDomainOwnershipAsync(domain).block();
    }

    @Override
    public Mono<Void> verifyDomainOwnershipAsync(AppServiceDomain domain) {
        return domain.verifyDomainOwnershipAsync(this.name(), this.domainVerificationToken());
    }

    @Override
    public String distinguishedName() {
        return ((AppServiceCertificateOrderInner)this.innerModel()).distinguishedName();
    }

    @Override
    public String domainVerificationToken() {
        return ((AppServiceCertificateOrderInner)this.innerModel()).domainVerificationToken();
    }

    @Override
    public int validityInYears() {
        return ResourceManagerUtils.toPrimitiveInt(((AppServiceCertificateOrderInner)this.innerModel()).validityInYears());
    }

    @Override
    public int keySize() {
        return ResourceManagerUtils.toPrimitiveInt(((AppServiceCertificateOrderInner)this.innerModel()).keySize());
    }

    @Override
    public CertificateProductType productType() {
        return ((AppServiceCertificateOrderInner)this.innerModel()).productType();
    }

    @Override
    public boolean autoRenew() {
        return ResourceManagerUtils.toPrimitiveBoolean(((AppServiceCertificateOrderInner)this.innerModel()).autoRenew());
    }

    @Override
    public CertificateOrderStatus status() {
        return ((AppServiceCertificateOrderInner)this.innerModel()).status();
    }

    @Override
    public CertificateDetails signedCertificate() {
        return ((AppServiceCertificateOrderInner)this.innerModel()).signedCertificate();
    }

    @Override
    public String certificateSigningRequest() {
        return ((AppServiceCertificateOrderInner)this.innerModel()).csr();
    }

    @Override
    public CertificateDetails intermediate() {
        return ((AppServiceCertificateOrderInner)this.innerModel()).intermediate();
    }

    @Override
    public CertificateDetails root() {
        return ((AppServiceCertificateOrderInner)this.innerModel()).root();
    }

    @Override
    public String serialNumber() {
        return ((AppServiceCertificateOrderInner)this.innerModel()).serialNumber();
    }

    @Override
    public OffsetDateTime lastCertificateIssuanceTime() {
        return ((AppServiceCertificateOrderInner)this.innerModel()).lastCertificateIssuanceTime();
    }

    @Override
    public OffsetDateTime expirationTime() {
        return ((AppServiceCertificateOrderInner)this.innerModel()).expirationTime();
    }

    @Override
    public AppServiceCertificateKeyVaultBinding createKeyVaultBinding(String certificateName, Vault vault) {
        return this.createKeyVaultBindingAsync(certificateName, vault).block();
    }

    @Override
    public Mono<AppServiceCertificateKeyVaultBinding> createKeyVaultBindingAsync(String certificateName, Vault vault) {
        AppServiceCertificateResourceInner certInner = new AppServiceCertificateResourceInner();
        certInner.withLocation(vault.regionName());
        certInner.withKeyVaultId(vault.id());
        certInner.withKeyVaultSecretName(certificateName);
        return ((WebSiteManagementClient)((AppServiceManager)this.manager()).serviceClient()).getAppServiceCertificateOrders().createOrUpdateCertificateAsync(this.resourceGroupName(), this.name(), certificateName, certInner).map(appServiceCertificateInner -> new AppServiceCertificateKeyVaultBindingImpl((AppServiceCertificateResourceInner)appServiceCertificateInner, this));
    }

    @Override
    public AppServiceCertificateOrderImpl withHostName(String hostName) {
        ((AppServiceCertificateOrderInner)this.innerModel()).withDistinguishedName("CN=" + hostName);
        return this;
    }

    @Override
    public AppServiceCertificateOrderImpl withStandardSku() {
        ((AppServiceCertificateOrderInner)this.innerModel()).withProductType(CertificateProductType.STANDARD_DOMAIN_VALIDATED_SSL);
        return this;
    }

    @Override
    public AppServiceCertificateOrderImpl withWildcardSku() {
        ((AppServiceCertificateOrderInner)this.innerModel()).withProductType(CertificateProductType.STANDARD_DOMAIN_VALIDATED_WILD_CARD_SSL);
        return this;
    }

    @Override
    public AppServiceCertificateOrderImpl withValidYears(int years) {
        ((AppServiceCertificateOrderInner)this.innerModel()).withValidityInYears(years);
        return this;
    }

    @Override
    public Mono<AppServiceCertificateOrder> createResourceAsync() {
        return ((WebSiteManagementClient)((AppServiceManager)this.manager()).serviceClient()).getAppServiceCertificateOrders().createOrUpdateAsync(this.resourceGroupName(), this.name(), (AppServiceCertificateOrderInner)this.innerModel()).map(this.innerToFluentMap(this)).then(Mono.defer(() -> {
            if (this.domainVerifyWebApp != null) {
                return this.domainVerifyWebApp.verifyDomainOwnershipAsync(this.name(), this.domainVerificationToken());
            }
            if (this.domainVerifyDomain != null) {
                return this.domainVerifyDomain.verifyDomainOwnershipAsync(this.name(), this.domainVerificationToken());
            }
            return Mono.error(new IllegalArgumentException("Please specify a non-null web app or domain to verify the domain ownership for hostname " + this.distinguishedName()));
        })).then(this.bindingVault.flatMap(vault -> this.createKeyVaultBindingAsync(this.name(), (Vault)vault))).then(Mono.just(this));
    }

    @Override
    public AppServiceCertificateOrderImpl withAutoRenew(boolean enabled) {
        ((AppServiceCertificateOrderInner)this.innerModel()).withAutoRenew(enabled);
        return this;
    }

    @Override
    public AppServiceCertificateOrderImpl withDomainVerification(AppServiceDomain domain) {
        this.domainVerifyDomain = domain;
        return this;
    }

    @Override
    public AppServiceCertificateOrderImpl withWebAppVerification(WebAppBase webApp) {
        this.domainVerifyWebApp = webApp;
        return this;
    }

    @Override
    public AppServiceCertificateOrderImpl withExistingKeyVault(Vault vault) {
        this.bindingVault = Mono.just(vault);
        return this;
    }

    @Override
    public AppServiceCertificateOrderImpl withNewKeyVault(String vaultName, Region region) {
        this.bindingVault = ((Vault.DefinitionStages.WithCreate)((Vault.DefinitionStages.WithCreate)((Vault.DefinitionStages.WithAccessPolicy)((Vault.DefinitionStages.WithGroup)((Vault.DefinitionStages.Blank)((AppServiceManager)this.myManager).keyVaultManager().vaults().define(vaultName)).withRegion(region)).withExistingResourceGroup(this.resourceGroupName())).defineAccessPolicy().forServicePrincipal("f3c21649-0979-4721-ac85-b0216b2cf413").allowSecretPermissions(SecretPermissions.GET, SecretPermissions.SET, SecretPermissions.DELETE).attach()).defineAccessPolicy().forServicePrincipal("abfa0a7c-a6b6-4736-8310-5855508787cd").allowSecretPermissions(SecretPermissions.GET).attach()).createAsync();
        return this;
    }
}

