/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.implementation;

import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedFlux;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedIterable;
import com.dataiku.dss.shadelibazure.com.azure.core.util.CoreUtils;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.AppServiceManager;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.fluent.WebAppsClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.fluent.WebSiteManagementClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.fluent.models.SiteConfigResourceInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.fluent.models.SiteInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.fluent.models.SiteLogsConfigInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.implementation.FunctionAppBasicImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.implementation.FunctionAppImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.implementation.FunctionEnvelopeImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.FunctionApp;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.FunctionAppBasic;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.FunctionApps;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.FunctionEnvelope;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.collection.SupportsBatchDeletion;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.collection.implementation.BatchDeletionImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.collection.implementation.GroupableResourcesImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.utils.PagedConverter;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Flux;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;

public class FunctionAppsImpl
extends GroupableResourcesImpl<FunctionApp, FunctionAppImpl, SiteInner, WebAppsClient, AppServiceManager>
implements FunctionApps,
SupportsBatchDeletion {
    public FunctionAppsImpl(AppServiceManager manager) {
        super(((WebSiteManagementClient)manager.serviceClient()).getWebApps(), manager);
    }

    @Override
    public FunctionApp getByResourceGroup(String groupName, String name) {
        return this.getByResourceGroupAsync(groupName, name).block();
    }

    @Override
    public Mono<FunctionApp> getByResourceGroupAsync(String resourceGroupName, String name) {
        if (CoreUtils.isNullOrEmpty(resourceGroupName)) {
            return Mono.error(new IllegalArgumentException("Parameter 'resourceGroupName' is required and cannot be null."));
        }
        if (CoreUtils.isNullOrEmpty(name)) {
            return Mono.error(new IllegalArgumentException("Parameter 'name' is required and cannot be null."));
        }
        return this.getInnerAsync(resourceGroupName, name).flatMap(siteInner -> {
            if (FunctionAppImpl.isFunctionAppOnACA(siteInner)) {
                return ((WebAppsClient)this.inner()).getConfigurationAsync(resourceGroupName, name).map(siteConfigResourceInner -> this.wrapModel((SiteInner)siteInner, (SiteConfigResourceInner)siteConfigResourceInner, null));
            }
            return Mono.zip(((WebAppsClient)this.inner()).getConfigurationAsync(resourceGroupName, name), ((WebAppsClient)this.inner()).getDiagnosticLogsConfigurationAsync(resourceGroupName, name), (siteConfigResourceInner, logsConfigInner) -> this.wrapModel((SiteInner)siteInner, (SiteConfigResourceInner)siteConfigResourceInner, (SiteLogsConfigInner)logsConfigInner));
        });
    }

    @Override
    protected Mono<SiteInner> getInnerAsync(String resourceGroupName, String name) {
        return ((WebAppsClient)this.inner()).getByResourceGroupAsync(resourceGroupName, name);
    }

    @Override
    public PagedIterable<FunctionEnvelope> listFunctions(String resourceGroupName, String name) {
        return PagedConverter.mapPage(((WebSiteManagementClient)((AppServiceManager)this.manager()).serviceClient()).getWebApps().listFunctions(resourceGroupName, name), FunctionEnvelopeImpl::new);
    }

    @Override
    protected Mono<Void> deleteInnerAsync(String resourceGroupName, String name) {
        return ((WebAppsClient)this.inner()).deleteAsync(resourceGroupName, name);
    }

    @Override
    protected FunctionAppImpl wrapModel(String name) {
        return new FunctionAppImpl(name, new SiteInner().withKind("functionapp"), null, null, (AppServiceManager)this.manager());
    }

    @Override
    protected FunctionAppImpl wrapModel(SiteInner inner) {
        if (inner == null) {
            return null;
        }
        return this.wrapModel(inner, null, null);
    }

    private FunctionAppImpl wrapModel(SiteInner inner, SiteConfigResourceInner siteConfig, SiteLogsConfigInner logConfig) {
        if (inner == null) {
            return null;
        }
        return new FunctionAppImpl(inner.name(), inner, siteConfig, logConfig, (AppServiceManager)this.manager());
    }

    @Override
    public FunctionAppImpl define(String name) {
        return this.wrapModel(name);
    }

    @Override
    public Mono<Void> deleteByResourceGroupAsync(String resourceGroupName, String name) {
        if (CoreUtils.isNullOrEmpty(resourceGroupName)) {
            return Mono.error(new IllegalArgumentException("Parameter 'resourceGroupName' is required and cannot be null."));
        }
        if (CoreUtils.isNullOrEmpty(name)) {
            return Mono.error(new IllegalArgumentException("Parameter 'name' is required and cannot be null."));
        }
        return ((WebAppsClient)this.inner()).deleteAsync(resourceGroupName, name);
    }

    @Override
    public Flux<String> deleteByIdsAsync(Collection<String> ids) {
        return BatchDeletionImpl.deleteByIdsAsync(ids, this::deleteInnerAsync);
    }

    @Override
    public Flux<String> deleteByIdsAsync(String ... ids) {
        return this.deleteByIdsAsync(new ArrayList<String>(Arrays.asList(ids)));
    }

    @Override
    public void deleteByIds(Collection<String> ids) {
        if (ids != null && !ids.isEmpty()) {
            this.deleteByIdsAsync(ids).blockLast();
        }
    }

    @Override
    public void deleteByIds(String ... ids) {
        this.deleteByIds(new ArrayList<String>(Arrays.asList(ids)));
    }

    @Override
    public PagedIterable<FunctionAppBasic> listByResourceGroup(String resourceGroupName) {
        return new PagedIterable<FunctionAppBasic>(this.listByResourceGroupAsync(resourceGroupName));
    }

    @Override
    public PagedFlux<FunctionAppBasic> listByResourceGroupAsync(String resourceGroupName) {
        if (CoreUtils.isNullOrEmpty(resourceGroupName)) {
            return new PagedFlux<FunctionAppBasic>(() -> Mono.error(new IllegalArgumentException("Parameter 'resourceGroupName' is required and cannot be null.")));
        }
        return PagedConverter.flatMapPage(((WebAppsClient)this.inner()).listByResourceGroupAsync(resourceGroupName), inner -> FunctionAppsImpl.isFunctionApp(inner) ? Mono.just(new FunctionAppBasicImpl((SiteInner)inner, (AppServiceManager)this.manager())) : Mono.empty());
    }

    @Override
    public PagedIterable<FunctionAppBasic> list() {
        return new PagedIterable<FunctionAppBasic>(this.listAsync());
    }

    @Override
    public PagedFlux<FunctionAppBasic> listAsync() {
        return PagedConverter.flatMapPage(((WebAppsClient)this.inner()).listAsync(), inner -> FunctionAppsImpl.isFunctionApp(inner) ? Mono.just(new FunctionAppBasicImpl((SiteInner)inner, (AppServiceManager)this.manager())) : Mono.empty());
    }

    private static boolean isFunctionApp(SiteInner inner) {
        List<String> kinds;
        boolean ret = false;
        if (inner.kind() != null && (kinds = Arrays.asList(inner.kind().split(Pattern.quote(",")))).contains("functionapp") && !kinds.contains("kubernetes")) {
            ret = true;
        }
        return ret;
    }
}

