/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.implementation;

import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ExpectedResponses;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Get;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.HeaderParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Headers;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Host;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.HostParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.PathParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.QueryParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ReturnType;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ServiceInterface;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ServiceMethod;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedFlux;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedIterable;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedResponse;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedResponseBase;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.Response;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.RestProxy;
import com.dataiku.dss.shadelibazure.com.azure.core.util.Context;
import com.dataiku.dss.shadelibazure.com.azure.core.util.FluxUtil;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.fluent.ResourceHealthMetadatasClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.fluent.models.ResourceHealthMetadataInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.implementation.WebSiteManagementClientImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.ResourceHealthMetadataCollection;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsListing;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;

public final class ResourceHealthMetadatasClientImpl
implements InnerSupportsListing<ResourceHealthMetadataInner>,
ResourceHealthMetadatasClient {
    private final ResourceHealthMetadatasService service;
    private final WebSiteManagementClientImpl client;

    ResourceHealthMetadatasClientImpl(WebSiteManagementClientImpl client) {
        this.service = RestProxy.create(ResourceHealthMetadatasService.class, client.getHttpPipeline(), client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ResourceHealthMetadataInner>> listSinglePageAsync() {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).map(res -> new PagedResponseBase<Object, ResourceHealthMetadataInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ResourceHealthMetadataCollection)res.getValue()).value(), ((ResourceHealthMetadataCollection)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ResourceHealthMetadataInner>> listSinglePageAsync(Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.list(this.client.getEndpoint(), this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context).map(res -> new PagedResponseBase<Object, ResourceHealthMetadataInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ResourceHealthMetadataCollection)res.getValue()).value(), ((ResourceHealthMetadataCollection)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<ResourceHealthMetadataInner> listAsync() {
        return new PagedFlux<ResourceHealthMetadataInner>(() -> this.listSinglePageAsync(), nextLink -> this.listNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<ResourceHealthMetadataInner> listAsync(Context context) {
        return new PagedFlux<ResourceHealthMetadataInner>(() -> this.listSinglePageAsync(context), nextLink -> this.listNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ResourceHealthMetadataInner> list() {
        return new PagedIterable<ResourceHealthMetadataInner>(this.listAsync());
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ResourceHealthMetadataInner> list(Context context) {
        return new PagedIterable<ResourceHealthMetadataInner>(this.listAsync(context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ResourceHealthMetadataInner>> listByResourceGroupSinglePageAsync(String resourceGroupName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByResourceGroup(this.client.getEndpoint(), resourceGroupName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).map(res -> new PagedResponseBase<Object, ResourceHealthMetadataInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ResourceHealthMetadataCollection)res.getValue()).value(), ((ResourceHealthMetadataCollection)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ResourceHealthMetadataInner>> listByResourceGroupSinglePageAsync(String resourceGroupName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByResourceGroup(this.client.getEndpoint(), resourceGroupName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context).map(res -> new PagedResponseBase<Object, ResourceHealthMetadataInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ResourceHealthMetadataCollection)res.getValue()).value(), ((ResourceHealthMetadataCollection)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<ResourceHealthMetadataInner> listByResourceGroupAsync(String resourceGroupName) {
        return new PagedFlux<ResourceHealthMetadataInner>(() -> this.listByResourceGroupSinglePageAsync(resourceGroupName), nextLink -> this.listByResourceGroupNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<ResourceHealthMetadataInner> listByResourceGroupAsync(String resourceGroupName, Context context) {
        return new PagedFlux<ResourceHealthMetadataInner>(() -> this.listByResourceGroupSinglePageAsync(resourceGroupName, context), nextLink -> this.listByResourceGroupNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ResourceHealthMetadataInner> listByResourceGroup(String resourceGroupName) {
        return new PagedIterable<ResourceHealthMetadataInner>(this.listByResourceGroupAsync(resourceGroupName));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ResourceHealthMetadataInner> listByResourceGroup(String resourceGroupName, Context context) {
        return new PagedIterable<ResourceHealthMetadataInner>(this.listByResourceGroupAsync(resourceGroupName, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ResourceHealthMetadataInner>> listBySiteSinglePageAsync(String resourceGroupName, String name) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listBySite(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).map(res -> new PagedResponseBase<Object, ResourceHealthMetadataInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ResourceHealthMetadataCollection)res.getValue()).value(), ((ResourceHealthMetadataCollection)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ResourceHealthMetadataInner>> listBySiteSinglePageAsync(String resourceGroupName, String name, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listBySite(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context).map(res -> new PagedResponseBase<Object, ResourceHealthMetadataInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ResourceHealthMetadataCollection)res.getValue()).value(), ((ResourceHealthMetadataCollection)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<ResourceHealthMetadataInner> listBySiteAsync(String resourceGroupName, String name) {
        return new PagedFlux<ResourceHealthMetadataInner>(() -> this.listBySiteSinglePageAsync(resourceGroupName, name), nextLink -> this.listBySiteNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<ResourceHealthMetadataInner> listBySiteAsync(String resourceGroupName, String name, Context context) {
        return new PagedFlux<ResourceHealthMetadataInner>(() -> this.listBySiteSinglePageAsync(resourceGroupName, name, context), nextLink -> this.listBySiteNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ResourceHealthMetadataInner> listBySite(String resourceGroupName, String name) {
        return new PagedIterable<ResourceHealthMetadataInner>(this.listBySiteAsync(resourceGroupName, name));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ResourceHealthMetadataInner> listBySite(String resourceGroupName, String name, Context context) {
        return new PagedIterable<ResourceHealthMetadataInner>(this.listBySiteAsync(resourceGroupName, name, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ResourceHealthMetadataInner>> getBySiteWithResponseAsync(String resourceGroupName, String name) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getBySite(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<ResourceHealthMetadataInner>> getBySiteWithResponseAsync(String resourceGroupName, String name, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getBySite(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResourceHealthMetadataInner> getBySiteAsync(String resourceGroupName, String name) {
        return this.getBySiteWithResponseAsync(resourceGroupName, name).flatMap(res -> Mono.justOrEmpty((ResourceHealthMetadataInner)res.getValue()));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ResourceHealthMetadataInner> getBySiteWithResponse(String resourceGroupName, String name, Context context) {
        return this.getBySiteWithResponseAsync(resourceGroupName, name, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ResourceHealthMetadataInner getBySite(String resourceGroupName, String name) {
        return this.getBySiteWithResponse(resourceGroupName, name, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ResourceHealthMetadataInner>> listBySiteSlotSinglePageAsync(String resourceGroupName, String name, String slot) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (slot == null) {
            return Mono.error(new IllegalArgumentException("Parameter slot is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listBySiteSlot(this.client.getEndpoint(), resourceGroupName, name, slot, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).map(res -> new PagedResponseBase<Object, ResourceHealthMetadataInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ResourceHealthMetadataCollection)res.getValue()).value(), ((ResourceHealthMetadataCollection)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ResourceHealthMetadataInner>> listBySiteSlotSinglePageAsync(String resourceGroupName, String name, String slot, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (slot == null) {
            return Mono.error(new IllegalArgumentException("Parameter slot is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listBySiteSlot(this.client.getEndpoint(), resourceGroupName, name, slot, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context).map(res -> new PagedResponseBase<Object, ResourceHealthMetadataInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ResourceHealthMetadataCollection)res.getValue()).value(), ((ResourceHealthMetadataCollection)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<ResourceHealthMetadataInner> listBySiteSlotAsync(String resourceGroupName, String name, String slot) {
        return new PagedFlux<ResourceHealthMetadataInner>(() -> this.listBySiteSlotSinglePageAsync(resourceGroupName, name, slot), nextLink -> this.listBySiteSlotNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<ResourceHealthMetadataInner> listBySiteSlotAsync(String resourceGroupName, String name, String slot, Context context) {
        return new PagedFlux<ResourceHealthMetadataInner>(() -> this.listBySiteSlotSinglePageAsync(resourceGroupName, name, slot, context), nextLink -> this.listBySiteSlotNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ResourceHealthMetadataInner> listBySiteSlot(String resourceGroupName, String name, String slot) {
        return new PagedIterable<ResourceHealthMetadataInner>(this.listBySiteSlotAsync(resourceGroupName, name, slot));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ResourceHealthMetadataInner> listBySiteSlot(String resourceGroupName, String name, String slot, Context context) {
        return new PagedIterable<ResourceHealthMetadataInner>(this.listBySiteSlotAsync(resourceGroupName, name, slot, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ResourceHealthMetadataInner>> getBySiteSlotWithResponseAsync(String resourceGroupName, String name, String slot) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (slot == null) {
            return Mono.error(new IllegalArgumentException("Parameter slot is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getBySiteSlot(this.client.getEndpoint(), resourceGroupName, name, slot, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<ResourceHealthMetadataInner>> getBySiteSlotWithResponseAsync(String resourceGroupName, String name, String slot, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (slot == null) {
            return Mono.error(new IllegalArgumentException("Parameter slot is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getBySiteSlot(this.client.getEndpoint(), resourceGroupName, name, slot, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResourceHealthMetadataInner> getBySiteSlotAsync(String resourceGroupName, String name, String slot) {
        return this.getBySiteSlotWithResponseAsync(resourceGroupName, name, slot).flatMap(res -> Mono.justOrEmpty((ResourceHealthMetadataInner)res.getValue()));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ResourceHealthMetadataInner> getBySiteSlotWithResponse(String resourceGroupName, String name, String slot, Context context) {
        return this.getBySiteSlotWithResponseAsync(resourceGroupName, name, slot, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ResourceHealthMetadataInner getBySiteSlot(String resourceGroupName, String name, String slot) {
        return this.getBySiteSlotWithResponse(resourceGroupName, name, slot, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ResourceHealthMetadataInner>> listNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase<Object, ResourceHealthMetadataInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ResourceHealthMetadataCollection)res.getValue()).value(), ((ResourceHealthMetadataCollection)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ResourceHealthMetadataInner>> listNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase<Object, ResourceHealthMetadataInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ResourceHealthMetadataCollection)res.getValue()).value(), ((ResourceHealthMetadataCollection)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ResourceHealthMetadataInner>> listByResourceGroupNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByResourceGroupNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase<Object, ResourceHealthMetadataInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ResourceHealthMetadataCollection)res.getValue()).value(), ((ResourceHealthMetadataCollection)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ResourceHealthMetadataInner>> listByResourceGroupNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByResourceGroupNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase<Object, ResourceHealthMetadataInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ResourceHealthMetadataCollection)res.getValue()).value(), ((ResourceHealthMetadataCollection)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ResourceHealthMetadataInner>> listBySiteNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listBySiteNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase<Object, ResourceHealthMetadataInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ResourceHealthMetadataCollection)res.getValue()).value(), ((ResourceHealthMetadataCollection)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ResourceHealthMetadataInner>> listBySiteNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listBySiteNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase<Object, ResourceHealthMetadataInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ResourceHealthMetadataCollection)res.getValue()).value(), ((ResourceHealthMetadataCollection)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ResourceHealthMetadataInner>> listBySiteSlotNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listBySiteSlotNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase<Object, ResourceHealthMetadataInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ResourceHealthMetadataCollection)res.getValue()).value(), ((ResourceHealthMetadataCollection)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ResourceHealthMetadataInner>> listBySiteSlotNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listBySiteSlotNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase<Object, ResourceHealthMetadataInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ResourceHealthMetadataCollection)res.getValue()).value(), ((ResourceHealthMetadataCollection)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="WebSiteManagementCli")
    public static interface ResourceHealthMetadatasService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.Web/resourceHealthMetadata")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<ResourceHealthMetadataCollection>> list(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/resourceHealthMetadata")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<ResourceHealthMetadataCollection>> listByResourceGroup(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="subscriptionId") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/resourceHealthMetadata")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<ResourceHealthMetadataCollection>> listBySite(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="name") String var3, @PathParam(value="subscriptionId") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/resourceHealthMetadata/default")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<ResourceHealthMetadataInner>> getBySite(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="name") String var3, @PathParam(value="subscriptionId") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/resourceHealthMetadata")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<ResourceHealthMetadataCollection>> listBySiteSlot(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="name") String var3, @PathParam(value="slot") String var4, @PathParam(value="subscriptionId") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/resourceHealthMetadata/default")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<ResourceHealthMetadataInner>> getBySiteSlot(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="name") String var3, @PathParam(value="slot") String var4, @PathParam(value="subscriptionId") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<ResourceHealthMetadataCollection>> listNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<ResourceHealthMetadataCollection>> listByResourceGroupNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<ResourceHealthMetadataCollection>> listBySiteNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<ResourceHealthMetadataCollection>> listBySiteSlotNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

