/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.implementation;

import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.fluent.models.SiteLogsConfigInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.implementation.WebAppBaseImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.ApplicationLogsConfig;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.AzureBlobStorageApplicationLogsConfig;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.AzureBlobStorageHttpLogsConfig;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.EnabledConfig;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.FileSystemApplicationLogsConfig;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.FileSystemHttpLogsConfig;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.HttpLogsConfig;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.LogLevel;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.WebAppBase;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.WebAppDiagnosticLogs;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.model.implementation.IndexableWrapperImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.utils.ResourceManagerUtils;

class WebAppDiagnosticLogsImpl<FluentT extends WebAppBase, FluentImplT extends WebAppBaseImpl<FluentT, FluentImplT>>
extends IndexableWrapperImpl<SiteLogsConfigInner>
implements WebAppDiagnosticLogs,
WebAppDiagnosticLogs.Definition<WebAppBase.DefinitionStages.WithCreate<FluentT>>,
WebAppDiagnosticLogs.UpdateDefinition<WebAppBase.Update<FluentT>> {
    private final WebAppBaseImpl<FluentT, FluentImplT> parent;
    private LogLevel applicationLogLevel = null;

    WebAppDiagnosticLogsImpl(SiteLogsConfigInner inner, WebAppBaseImpl<FluentT, FluentImplT> parent) {
        super(inner);
        if (inner.applicationLogs() != null) {
            inner.applicationLogs().withAzureTableStorage(null);
        }
        this.parent = parent;
    }

    @Override
    public LogLevel applicationLoggingFileSystemLogLevel() {
        if (((SiteLogsConfigInner)this.innerModel()).applicationLogs() == null || ((SiteLogsConfigInner)this.innerModel()).applicationLogs().fileSystem() == null || ((SiteLogsConfigInner)this.innerModel()).applicationLogs().fileSystem().level() == null) {
            return LogLevel.OFF;
        }
        return ((SiteLogsConfigInner)this.innerModel()).applicationLogs().fileSystem().level();
    }

    @Override
    public String applicationLoggingStorageBlobContainer() {
        if (((SiteLogsConfigInner)this.innerModel()).applicationLogs() == null || ((SiteLogsConfigInner)this.innerModel()).applicationLogs().azureBlobStorage() == null) {
            return null;
        }
        return ((SiteLogsConfigInner)this.innerModel()).applicationLogs().azureBlobStorage().sasUrl();
    }

    @Override
    public LogLevel applicationLoggingStorageBlobLogLevel() {
        if (((SiteLogsConfigInner)this.innerModel()).applicationLogs() == null || ((SiteLogsConfigInner)this.innerModel()).applicationLogs().azureBlobStorage() == null || ((SiteLogsConfigInner)this.innerModel()).applicationLogs().azureBlobStorage().level() == null) {
            return LogLevel.OFF;
        }
        return ((SiteLogsConfigInner)this.innerModel()).applicationLogs().azureBlobStorage().level();
    }

    @Override
    public int applicationLoggingStorageBlobRetentionDays() {
        if (((SiteLogsConfigInner)this.innerModel()).applicationLogs() == null || ((SiteLogsConfigInner)this.innerModel()).applicationLogs().azureBlobStorage() == null) {
            return 0;
        }
        return ResourceManagerUtils.toPrimitiveInt(((SiteLogsConfigInner)this.innerModel()).applicationLogs().azureBlobStorage().retentionInDays());
    }

    @Override
    public int webServerLoggingFileSystemQuotaInMB() {
        if (((SiteLogsConfigInner)this.innerModel()).httpLogs() == null || ((SiteLogsConfigInner)this.innerModel()).httpLogs().fileSystem() == null) {
            return 0;
        }
        return ResourceManagerUtils.toPrimitiveInt(((SiteLogsConfigInner)this.innerModel()).httpLogs().fileSystem().retentionInMb());
    }

    @Override
    public int webServerLoggingFileSystemRetentionDays() {
        if (((SiteLogsConfigInner)this.innerModel()).httpLogs() == null || ((SiteLogsConfigInner)this.innerModel()).httpLogs().fileSystem() == null) {
            return 0;
        }
        return ResourceManagerUtils.toPrimitiveInt(((SiteLogsConfigInner)this.innerModel()).httpLogs().fileSystem().retentionInDays());
    }

    @Override
    public int webServerLoggingStorageBlobRetentionDays() {
        if (((SiteLogsConfigInner)this.innerModel()).httpLogs() == null || ((SiteLogsConfigInner)this.innerModel()).httpLogs().azureBlobStorage() == null) {
            return 0;
        }
        return ResourceManagerUtils.toPrimitiveInt(((SiteLogsConfigInner)this.innerModel()).httpLogs().azureBlobStorage().retentionInDays());
    }

    @Override
    public String webServerLoggingStorageBlobContainer() {
        if (((SiteLogsConfigInner)this.innerModel()).httpLogs() == null || ((SiteLogsConfigInner)this.innerModel()).httpLogs().azureBlobStorage() == null) {
            return null;
        }
        return ((SiteLogsConfigInner)this.innerModel()).httpLogs().azureBlobStorage().sasUrl();
    }

    @Override
    public boolean failedRequestsTracing() {
        return ((SiteLogsConfigInner)this.innerModel()).failedRequestsTracing() != null && ResourceManagerUtils.toPrimitiveBoolean(((SiteLogsConfigInner)this.innerModel()).failedRequestsTracing().enabled());
    }

    @Override
    public boolean detailedErrorMessages() {
        return ((SiteLogsConfigInner)this.innerModel()).detailedErrorMessages() != null && ResourceManagerUtils.toPrimitiveBoolean(((SiteLogsConfigInner)this.innerModel()).detailedErrorMessages().enabled());
    }

    @Override
    public FluentImplT attach() {
        this.parent.withDiagnosticLogs(this);
        return (FluentImplT)this.parent();
    }

    @Override
    public FluentImplT parent() {
        this.parent.withDiagnosticLogs(this);
        return (FluentImplT)this.parent;
    }

    public WebAppDiagnosticLogsImpl<FluentT, FluentImplT> withApplicationLogging() {
        ((SiteLogsConfigInner)this.innerModel()).withApplicationLogs(new ApplicationLogsConfig());
        return this;
    }

    public WebAppDiagnosticLogsImpl<FluentT, FluentImplT> withoutApplicationLogging() {
        this.withoutApplicationLogsStoredOnFileSystem();
        this.withoutApplicationLogsStoredOnStorageBlob();
        return this;
    }

    public WebAppDiagnosticLogsImpl<FluentT, FluentImplT> withWebServerLogging() {
        ((SiteLogsConfigInner)this.innerModel()).withHttpLogs(new HttpLogsConfig());
        return this;
    }

    public WebAppDiagnosticLogsImpl<FluentT, FluentImplT> withoutWebServerLogging() {
        this.withoutWebServerLogsStoredOnFileSystem();
        this.withoutWebServerLogsStoredOnStorageBlob();
        return this;
    }

    public WebAppDiagnosticLogsImpl<FluentT, FluentImplT> withDetailedErrorMessages(boolean enabled) {
        ((SiteLogsConfigInner)this.innerModel()).withDetailedErrorMessages(new EnabledConfig().withEnabled(enabled));
        return this;
    }

    public WebAppDiagnosticLogsImpl<FluentT, FluentImplT> withFailedRequestTracing(boolean enabled) {
        ((SiteLogsConfigInner)this.innerModel()).withFailedRequestsTracing(new EnabledConfig().withEnabled(enabled));
        return this;
    }

    public WebAppDiagnosticLogsImpl<FluentT, FluentImplT> withApplicationLogsStoredOnFileSystem() {
        if (((SiteLogsConfigInner)this.innerModel()).applicationLogs() != null) {
            ((SiteLogsConfigInner)this.innerModel()).applicationLogs().withFileSystem(new FileSystemApplicationLogsConfig().withLevel(this.applicationLogLevel));
        }
        return this;
    }

    public WebAppDiagnosticLogsImpl<FluentT, FluentImplT> withApplicationLogsStoredOnStorageBlob(String containerSasUrl) {
        if (((SiteLogsConfigInner)this.innerModel()).applicationLogs() != null) {
            ((SiteLogsConfigInner)this.innerModel()).applicationLogs().withAzureBlobStorage(new AzureBlobStorageApplicationLogsConfig().withLevel(this.applicationLogLevel).withSasUrl(containerSasUrl));
        }
        return this;
    }

    public WebAppDiagnosticLogsImpl<FluentT, FluentImplT> withWebServerLogsStoredOnFileSystem() {
        if (((SiteLogsConfigInner)this.innerModel()).httpLogs() != null) {
            ((SiteLogsConfigInner)this.innerModel()).httpLogs().withFileSystem(new FileSystemHttpLogsConfig().withEnabled(true));
        }
        return this;
    }

    public WebAppDiagnosticLogsImpl<FluentT, FluentImplT> withWebServerLogsStoredOnStorageBlob(String containerSasUrl) {
        if (((SiteLogsConfigInner)this.innerModel()).httpLogs() != null) {
            ((SiteLogsConfigInner)this.innerModel()).httpLogs().withAzureBlobStorage(new AzureBlobStorageHttpLogsConfig().withEnabled(true).withSasUrl(containerSasUrl));
        }
        return this;
    }

    public WebAppDiagnosticLogsImpl<FluentT, FluentImplT> withoutWebServerLogsStoredOnFileSystem() {
        if (((SiteLogsConfigInner)this.innerModel()).httpLogs() != null && ((SiteLogsConfigInner)this.innerModel()).httpLogs().fileSystem() != null) {
            ((SiteLogsConfigInner)this.innerModel()).httpLogs().fileSystem().withEnabled(false);
        }
        return this;
    }

    public WebAppDiagnosticLogsImpl<FluentT, FluentImplT> withoutWebServerLogsStoredOnStorageBlob() {
        if (((SiteLogsConfigInner)this.innerModel()).httpLogs() != null && ((SiteLogsConfigInner)this.innerModel()).httpLogs().azureBlobStorage() != null) {
            ((SiteLogsConfigInner)this.innerModel()).httpLogs().azureBlobStorage().withEnabled(false);
        }
        return this;
    }

    public WebAppDiagnosticLogsImpl<FluentT, FluentImplT> withLogLevel(LogLevel logLevel) {
        this.applicationLogLevel = logLevel;
        return this;
    }

    public WebAppDiagnosticLogsImpl<FluentT, FluentImplT> withWebServerFileSystemQuotaInMB(int quotaInMB) {
        if (((SiteLogsConfigInner)this.innerModel()).httpLogs() != null && ((SiteLogsConfigInner)this.innerModel()).httpLogs().fileSystem() != null && ((SiteLogsConfigInner)this.innerModel()).httpLogs().fileSystem().enabled().booleanValue()) {
            ((SiteLogsConfigInner)this.innerModel()).httpLogs().fileSystem().withRetentionInMb(quotaInMB);
        }
        return this;
    }

    public WebAppDiagnosticLogsImpl<FluentT, FluentImplT> withLogRetentionDays(int retentionDays) {
        if (((SiteLogsConfigInner)this.innerModel()).httpLogs() != null && ((SiteLogsConfigInner)this.innerModel()).httpLogs().fileSystem() != null && ((SiteLogsConfigInner)this.innerModel()).httpLogs().fileSystem().enabled().booleanValue()) {
            ((SiteLogsConfigInner)this.innerModel()).httpLogs().fileSystem().withRetentionInDays(retentionDays);
        }
        if (((SiteLogsConfigInner)this.innerModel()).httpLogs() != null && ((SiteLogsConfigInner)this.innerModel()).httpLogs().azureBlobStorage() != null && ((SiteLogsConfigInner)this.innerModel()).httpLogs().azureBlobStorage().enabled().booleanValue()) {
            ((SiteLogsConfigInner)this.innerModel()).httpLogs().azureBlobStorage().withRetentionInDays(retentionDays);
        }
        return this;
    }

    public WebAppDiagnosticLogsImpl<FluentT, FluentImplT> withUnlimitedLogRetentionDays() {
        if (((SiteLogsConfigInner)this.innerModel()).httpLogs() != null && ((SiteLogsConfigInner)this.innerModel()).httpLogs().fileSystem() != null && ((SiteLogsConfigInner)this.innerModel()).httpLogs().fileSystem().enabled().booleanValue()) {
            ((SiteLogsConfigInner)this.innerModel()).httpLogs().fileSystem().withRetentionInDays(0);
        }
        if (((SiteLogsConfigInner)this.innerModel()).httpLogs() != null && ((SiteLogsConfigInner)this.innerModel()).httpLogs().azureBlobStorage() != null && ((SiteLogsConfigInner)this.innerModel()).httpLogs().fileSystem().enabled().booleanValue()) {
            ((SiteLogsConfigInner)this.innerModel()).httpLogs().azureBlobStorage().withRetentionInDays(0);
        }
        return this;
    }

    public WebAppDiagnosticLogsImpl<FluentT, FluentImplT> withoutApplicationLogsStoredOnFileSystem() {
        if (((SiteLogsConfigInner)this.innerModel()).applicationLogs() != null && ((SiteLogsConfigInner)this.innerModel()).applicationLogs().fileSystem() != null) {
            ((SiteLogsConfigInner)this.innerModel()).applicationLogs().fileSystem().withLevel(LogLevel.OFF);
        }
        return this;
    }

    public WebAppDiagnosticLogsImpl<FluentT, FluentImplT> withoutApplicationLogsStoredOnStorageBlob() {
        if (((SiteLogsConfigInner)this.innerModel()).applicationLogs() != null && ((SiteLogsConfigInner)this.innerModel()).applicationLogs().azureBlobStorage() != null) {
            ((SiteLogsConfigInner)this.innerModel()).applicationLogs().azureBlobStorage().withLevel(LogLevel.OFF);
        }
        return this;
    }
}

