/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.implementation;

import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.AppServiceManager;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.fluent.WebSiteManagementClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.fluent.models.SiteSourceControlInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.fluent.models.SourceControlInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.implementation.WebAppBaseImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.RepositoryType;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.WebAppBase;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.WebAppSourceControl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.models.implementation.GroupableResourceImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.model.implementation.IndexableWrapperImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.utils.ResourceManagerUtils;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;

class WebAppSourceControlImpl<FluentT extends WebAppBase, FluentImplT extends WebAppBaseImpl<FluentT, FluentImplT>>
extends IndexableWrapperImpl<SiteSourceControlInner>
implements WebAppSourceControl,
WebAppSourceControl.Definition<WebAppBase.DefinitionStages.WithCreate<FluentT>>,
WebAppSourceControl.UpdateDefinition<WebAppBase.Update<FluentT>> {
    private final WebAppBaseImpl<FluentT, FluentImplT> parent;
    private String githubAccessToken;

    WebAppSourceControlImpl(SiteSourceControlInner inner, WebAppBaseImpl<FluentT, FluentImplT> parent) {
        super(inner);
        this.parent = parent;
    }

    @Override
    public String name() {
        return ((SiteSourceControlInner)this.innerModel()).name();
    }

    @Override
    public String repositoryUrl() {
        return ((SiteSourceControlInner)this.innerModel()).repoUrl();
    }

    @Override
    public String branch() {
        return ((SiteSourceControlInner)this.innerModel()).branch();
    }

    @Override
    public boolean isManualIntegration() {
        return ResourceManagerUtils.toPrimitiveBoolean(((SiteSourceControlInner)this.innerModel()).isManualIntegration());
    }

    @Override
    public boolean deploymentRollbackEnabled() {
        return ResourceManagerUtils.toPrimitiveBoolean(((SiteSourceControlInner)this.innerModel()).deploymentRollbackEnabled());
    }

    @Override
    public RepositoryType repositoryType() {
        if (((SiteSourceControlInner)this.innerModel()).isMercurial() == null) {
            return null;
        }
        return ((SiteSourceControlInner)this.innerModel()).isMercurial() != false ? RepositoryType.MERCURIAL : RepositoryType.GIT;
    }

    @Override
    public FluentImplT attach() {
        ((WebAppBaseImpl)this.parent()).withSourceControl(this);
        return (FluentImplT)this.parent();
    }

    @Override
    public FluentImplT parent() {
        return (FluentImplT)this.parent;
    }

    public WebAppSourceControlImpl<FluentT, FluentImplT> withBranch(String branch) {
        ((SiteSourceControlInner)this.innerModel()).withBranch(branch);
        return this;
    }

    public WebAppSourceControlImpl<FluentT, FluentImplT> withPublicGitRepository(String url) {
        ((SiteSourceControlInner)this.innerModel()).withIsManualIntegration(true).withIsMercurial(false).withRepoUrl(url);
        return this;
    }

    public WebAppSourceControlImpl<FluentT, FluentImplT> withPublicMercurialRepository(String url) {
        ((SiteSourceControlInner)this.innerModel()).withIsManualIntegration(true).withIsMercurial(true).withRepoUrl(url);
        return this;
    }

    public WebAppSourceControlImpl<FluentT, FluentImplT> withContinuouslyIntegratedGitHubRepository(String organization, String repository) {
        return this.withContinuouslyIntegratedGitHubRepository(String.format("https://github.com/%s/%s", organization, repository));
    }

    public WebAppSourceControlImpl<FluentT, FluentImplT> withContinuouslyIntegratedGitHubRepository(String url) {
        ((SiteSourceControlInner)this.innerModel()).withRepoUrl(url).withIsMercurial(false).withIsManualIntegration(false);
        return this;
    }

    public WebAppSourceControlImpl<FluentT, FluentImplT> withGitHubAccessToken(String personalAccessToken) {
        this.githubAccessToken = personalAccessToken;
        return this;
    }

    Mono<SourceControlInner> registerGithubAccessToken() {
        if (this.githubAccessToken == null) {
            return Mono.empty();
        }
        SourceControlInner sourceControlInner = new SourceControlInner().withToken(this.githubAccessToken);
        return ((WebSiteManagementClient)((AppServiceManager)((GroupableResourceImpl)this.parent()).manager()).serviceClient()).getResourceProviders().updateSourceControlAsync("Github", sourceControlInner);
    }
}

