/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models;

import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.AzureBlobStorageApplicationLogsConfig;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.AzureTableStorageApplicationLogsConfig;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.FileSystemApplicationLogsConfig;
import java.io.IOException;

public final class ApplicationLogsConfig
implements JsonSerializable<ApplicationLogsConfig> {
    private FileSystemApplicationLogsConfig fileSystem;
    private AzureTableStorageApplicationLogsConfig azureTableStorage;
    private AzureBlobStorageApplicationLogsConfig azureBlobStorage;

    public FileSystemApplicationLogsConfig fileSystem() {
        return this.fileSystem;
    }

    public ApplicationLogsConfig withFileSystem(FileSystemApplicationLogsConfig fileSystem) {
        this.fileSystem = fileSystem;
        return this;
    }

    public AzureTableStorageApplicationLogsConfig azureTableStorage() {
        return this.azureTableStorage;
    }

    public ApplicationLogsConfig withAzureTableStorage(AzureTableStorageApplicationLogsConfig azureTableStorage) {
        this.azureTableStorage = azureTableStorage;
        return this;
    }

    public AzureBlobStorageApplicationLogsConfig azureBlobStorage() {
        return this.azureBlobStorage;
    }

    public ApplicationLogsConfig withAzureBlobStorage(AzureBlobStorageApplicationLogsConfig azureBlobStorage) {
        this.azureBlobStorage = azureBlobStorage;
        return this;
    }

    public void validate() {
        if (this.fileSystem() != null) {
            this.fileSystem().validate();
        }
        if (this.azureTableStorage() != null) {
            this.azureTableStorage().validate();
        }
        if (this.azureBlobStorage() != null) {
            this.azureBlobStorage().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("fileSystem", this.fileSystem);
        jsonWriter.writeJsonField("azureTableStorage", this.azureTableStorage);
        jsonWriter.writeJsonField("azureBlobStorage", this.azureBlobStorage);
        return jsonWriter.writeEndObject();
    }

    public static ApplicationLogsConfig fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ApplicationLogsConfig deserializedApplicationLogsConfig = new ApplicationLogsConfig();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("fileSystem".equals(fieldName)) {
                    deserializedApplicationLogsConfig.fileSystem = FileSystemApplicationLogsConfig.fromJson(reader);
                    continue;
                }
                if ("azureTableStorage".equals(fieldName)) {
                    deserializedApplicationLogsConfig.azureTableStorage = AzureTableStorageApplicationLogsConfig.fromJson(reader);
                    continue;
                }
                if ("azureBlobStorage".equals(fieldName)) {
                    deserializedApplicationLogsConfig.azureBlobStorage = AzureBlobStorageApplicationLogsConfig.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedApplicationLogsConfig;
        });
    }
}

