/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models;

import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.ContainerCpuUsage;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.ContainerThrottlingData;
import java.io.IOException;

public final class ContainerCpuStatistics
implements JsonSerializable<ContainerCpuStatistics> {
    private ContainerCpuUsage cpuUsage;
    private Long systemCpuUsage;
    private Integer onlineCpuCount;
    private ContainerThrottlingData throttlingData;

    public ContainerCpuUsage cpuUsage() {
        return this.cpuUsage;
    }

    public ContainerCpuStatistics withCpuUsage(ContainerCpuUsage cpuUsage) {
        this.cpuUsage = cpuUsage;
        return this;
    }

    public Long systemCpuUsage() {
        return this.systemCpuUsage;
    }

    public ContainerCpuStatistics withSystemCpuUsage(Long systemCpuUsage) {
        this.systemCpuUsage = systemCpuUsage;
        return this;
    }

    public Integer onlineCpuCount() {
        return this.onlineCpuCount;
    }

    public ContainerCpuStatistics withOnlineCpuCount(Integer onlineCpuCount) {
        this.onlineCpuCount = onlineCpuCount;
        return this;
    }

    public ContainerThrottlingData throttlingData() {
        return this.throttlingData;
    }

    public ContainerCpuStatistics withThrottlingData(ContainerThrottlingData throttlingData) {
        this.throttlingData = throttlingData;
        return this;
    }

    public void validate() {
        if (this.cpuUsage() != null) {
            this.cpuUsage().validate();
        }
        if (this.throttlingData() != null) {
            this.throttlingData().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("cpuUsage", this.cpuUsage);
        jsonWriter.writeNumberField("systemCpuUsage", this.systemCpuUsage);
        jsonWriter.writeNumberField("onlineCpuCount", this.onlineCpuCount);
        jsonWriter.writeJsonField("throttlingData", this.throttlingData);
        return jsonWriter.writeEndObject();
    }

    public static ContainerCpuStatistics fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ContainerCpuStatistics deserializedContainerCpuStatistics = new ContainerCpuStatistics();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("cpuUsage".equals(fieldName)) {
                    deserializedContainerCpuStatistics.cpuUsage = ContainerCpuUsage.fromJson(reader);
                    continue;
                }
                if ("systemCpuUsage".equals(fieldName)) {
                    deserializedContainerCpuStatistics.systemCpuUsage = reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("onlineCpuCount".equals(fieldName)) {
                    deserializedContainerCpuStatistics.onlineCpuCount = reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("throttlingData".equals(fieldName)) {
                    deserializedContainerCpuStatistics.throttlingData = ContainerThrottlingData.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedContainerCpuStatistics;
        });
    }
}

