/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models;

import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.IngressTransportMethod;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.TrafficWeight;
import java.io.IOException;
import java.util.List;

public final class Ingress
implements JsonSerializable<Ingress> {
    private String fqdn;
    private Boolean external;
    private Integer targetPort;
    private IngressTransportMethod transport;
    private List<TrafficWeight> traffic;
    private Boolean allowInsecure;

    public String fqdn() {
        return this.fqdn;
    }

    public Boolean external() {
        return this.external;
    }

    public Ingress withExternal(Boolean external) {
        this.external = external;
        return this;
    }

    public Integer targetPort() {
        return this.targetPort;
    }

    public Ingress withTargetPort(Integer targetPort) {
        this.targetPort = targetPort;
        return this;
    }

    public IngressTransportMethod transport() {
        return this.transport;
    }

    public Ingress withTransport(IngressTransportMethod transport) {
        this.transport = transport;
        return this;
    }

    public List<TrafficWeight> traffic() {
        return this.traffic;
    }

    public Ingress withTraffic(List<TrafficWeight> traffic) {
        this.traffic = traffic;
        return this;
    }

    public Boolean allowInsecure() {
        return this.allowInsecure;
    }

    public Ingress withAllowInsecure(Boolean allowInsecure) {
        this.allowInsecure = allowInsecure;
        return this;
    }

    public void validate() {
        if (this.traffic() != null) {
            this.traffic().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("external", this.external);
        jsonWriter.writeNumberField("targetPort", this.targetPort);
        jsonWriter.writeStringField("transport", this.transport == null ? null : this.transport.toString());
        jsonWriter.writeArrayField("traffic", this.traffic, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        jsonWriter.writeBooleanField("allowInsecure", this.allowInsecure);
        return jsonWriter.writeEndObject();
    }

    public static Ingress fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            Ingress deserializedIngress = new Ingress();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("fqdn".equals(fieldName)) {
                    deserializedIngress.fqdn = reader.getString();
                    continue;
                }
                if ("external".equals(fieldName)) {
                    deserializedIngress.external = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("targetPort".equals(fieldName)) {
                    deserializedIngress.targetPort = reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("transport".equals(fieldName)) {
                    deserializedIngress.transport = IngressTransportMethod.fromString(reader.getString());
                    continue;
                }
                if ("traffic".equals(fieldName)) {
                    List<TrafficWeight> traffic = reader.readArray(reader1 -> TrafficWeight.fromJson(reader1));
                    deserializedIngress.traffic = traffic;
                    continue;
                }
                if ("allowInsecure".equals(fieldName)) {
                    deserializedIngress.allowInsecure = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedIngress;
        });
    }
}

