/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.CoreUtils;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.PerfMonSample;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;

public final class PerfMonSet
implements JsonSerializable<PerfMonSet> {
    private String name;
    private OffsetDateTime startTime;
    private OffsetDateTime endTime;
    private String timeGrain;
    private List<PerfMonSample> values;

    public String name() {
        return this.name;
    }

    public PerfMonSet withName(String name) {
        this.name = name;
        return this;
    }

    public OffsetDateTime startTime() {
        return this.startTime;
    }

    public PerfMonSet withStartTime(OffsetDateTime startTime) {
        this.startTime = startTime;
        return this;
    }

    public OffsetDateTime endTime() {
        return this.endTime;
    }

    public PerfMonSet withEndTime(OffsetDateTime endTime) {
        this.endTime = endTime;
        return this;
    }

    public String timeGrain() {
        return this.timeGrain;
    }

    public PerfMonSet withTimeGrain(String timeGrain) {
        this.timeGrain = timeGrain;
        return this;
    }

    public List<PerfMonSample> values() {
        return this.values;
    }

    public PerfMonSet withValues(List<PerfMonSample> values2) {
        this.values = values2;
        return this;
    }

    public void validate() {
        if (this.values() != null) {
            this.values().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("startTime", this.startTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.startTime));
        jsonWriter.writeStringField("endTime", this.endTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.endTime));
        jsonWriter.writeStringField("timeGrain", this.timeGrain);
        jsonWriter.writeArrayField("values", this.values, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        return jsonWriter.writeEndObject();
    }

    public static PerfMonSet fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            PerfMonSet deserializedPerfMonSet = new PerfMonSet();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedPerfMonSet.name = reader.getString();
                    continue;
                }
                if ("startTime".equals(fieldName)) {
                    deserializedPerfMonSet.startTime = reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                    continue;
                }
                if ("endTime".equals(fieldName)) {
                    deserializedPerfMonSet.endTime = reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                    continue;
                }
                if ("timeGrain".equals(fieldName)) {
                    deserializedPerfMonSet.timeGrain = reader.getString();
                    continue;
                }
                if ("values".equals(fieldName)) {
                    List<PerfMonSample> values2 = reader.readArray(reader1 -> PerfMonSample.fromJson(reader1));
                    deserializedPerfMonSet.values = values2;
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedPerfMonSet;
        });
    }
}

