/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.CheckNameResourceTypes;
import java.io.IOException;

public final class ResourceNameAvailabilityRequest
implements JsonSerializable<ResourceNameAvailabilityRequest> {
    private String name;
    private CheckNameResourceTypes type;
    private Boolean isFqdn;
    private String environmentId;
    private static final ClientLogger LOGGER = new ClientLogger(ResourceNameAvailabilityRequest.class);

    public String name() {
        return this.name;
    }

    public ResourceNameAvailabilityRequest withName(String name) {
        this.name = name;
        return this;
    }

    public CheckNameResourceTypes type() {
        return this.type;
    }

    public ResourceNameAvailabilityRequest withType(CheckNameResourceTypes type) {
        this.type = type;
        return this;
    }

    public Boolean isFqdn() {
        return this.isFqdn;
    }

    public ResourceNameAvailabilityRequest withIsFqdn(Boolean isFqdn) {
        this.isFqdn = isFqdn;
        return this;
    }

    public String environmentId() {
        return this.environmentId;
    }

    public ResourceNameAvailabilityRequest withEnvironmentId(String environmentId) {
        this.environmentId = environmentId;
        return this;
    }

    public void validate() {
        if (this.name() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property name in model ResourceNameAvailabilityRequest"));
        }
        if (this.type() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property type in model ResourceNameAvailabilityRequest"));
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeBooleanField("isFqdn", this.isFqdn);
        jsonWriter.writeStringField("environmentId", this.environmentId);
        return jsonWriter.writeEndObject();
    }

    public static ResourceNameAvailabilityRequest fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ResourceNameAvailabilityRequest deserializedResourceNameAvailabilityRequest = new ResourceNameAvailabilityRequest();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedResourceNameAvailabilityRequest.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedResourceNameAvailabilityRequest.type = CheckNameResourceTypes.fromString(reader.getString());
                    continue;
                }
                if ("isFqdn".equals(fieldName)) {
                    deserializedResourceNameAvailabilityRequest.isFqdn = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("environmentId".equals(fieldName)) {
                    deserializedResourceNameAvailabilityRequest.environmentId = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedResourceNameAvailabilityRequest;
        });
    }
}

