/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models;

import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.ScaleRule;
import java.io.IOException;
import java.util.List;

public final class Scale
implements JsonSerializable<Scale> {
    private Integer minReplicas;
    private Integer maxReplicas;
    private List<ScaleRule> rules;

    public Integer minReplicas() {
        return this.minReplicas;
    }

    public Scale withMinReplicas(Integer minReplicas) {
        this.minReplicas = minReplicas;
        return this;
    }

    public Integer maxReplicas() {
        return this.maxReplicas;
    }

    public Scale withMaxReplicas(Integer maxReplicas) {
        this.maxReplicas = maxReplicas;
        return this;
    }

    public List<ScaleRule> rules() {
        return this.rules;
    }

    public Scale withRules(List<ScaleRule> rules) {
        this.rules = rules;
        return this;
    }

    public void validate() {
        if (this.rules() != null) {
            this.rules().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("minReplicas", this.minReplicas);
        jsonWriter.writeNumberField("maxReplicas", this.maxReplicas);
        jsonWriter.writeArrayField("rules", this.rules, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        return jsonWriter.writeEndObject();
    }

    public static Scale fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            Scale deserializedScale = new Scale();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("minReplicas".equals(fieldName)) {
                    deserializedScale.minReplicas = reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("maxReplicas".equals(fieldName)) {
                    deserializedScale.maxReplicas = reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("rules".equals(fieldName)) {
                    List<ScaleRule> rules = reader.readArray(reader1 -> ScaleRule.fromJson(reader1));
                    deserializedScale.rules = rules;
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedScale;
        });
    }
}

