/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models;

import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.BlobStorageTokenStore;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.FileSystemTokenStore;
import java.io.IOException;

public final class TokenStore
implements JsonSerializable<TokenStore> {
    private Boolean enabled;
    private Double tokenRefreshExtensionHours;
    private FileSystemTokenStore fileSystem;
    private BlobStorageTokenStore azureBlobStorage;

    public Boolean enabled() {
        return this.enabled;
    }

    public TokenStore withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public Double tokenRefreshExtensionHours() {
        return this.tokenRefreshExtensionHours;
    }

    public TokenStore withTokenRefreshExtensionHours(Double tokenRefreshExtensionHours) {
        this.tokenRefreshExtensionHours = tokenRefreshExtensionHours;
        return this;
    }

    public FileSystemTokenStore fileSystem() {
        return this.fileSystem;
    }

    public TokenStore withFileSystem(FileSystemTokenStore fileSystem) {
        this.fileSystem = fileSystem;
        return this;
    }

    public BlobStorageTokenStore azureBlobStorage() {
        return this.azureBlobStorage;
    }

    public TokenStore withAzureBlobStorage(BlobStorageTokenStore azureBlobStorage) {
        this.azureBlobStorage = azureBlobStorage;
        return this;
    }

    public void validate() {
        if (this.fileSystem() != null) {
            this.fileSystem().validate();
        }
        if (this.azureBlobStorage() != null) {
            this.azureBlobStorage().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("enabled", this.enabled);
        jsonWriter.writeNumberField("tokenRefreshExtensionHours", this.tokenRefreshExtensionHours);
        jsonWriter.writeJsonField("fileSystem", this.fileSystem);
        jsonWriter.writeJsonField("azureBlobStorage", this.azureBlobStorage);
        return jsonWriter.writeEndObject();
    }

    public static TokenStore fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            TokenStore deserializedTokenStore = new TokenStore();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("enabled".equals(fieldName)) {
                    deserializedTokenStore.enabled = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("tokenRefreshExtensionHours".equals(fieldName)) {
                    deserializedTokenStore.tokenRefreshExtensionHours = reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                if ("fileSystem".equals(fieldName)) {
                    deserializedTokenStore.fileSystem = FileSystemTokenStore.fromJson(reader);
                    continue;
                }
                if ("azureBlobStorage".equals(fieldName)) {
                    deserializedTokenStore.azureBlobStorage = BlobStorageTokenStore.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedTokenStore;
        });
    }
}

