/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.CoreUtils;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.TriggeredWebJobStatus;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public final class TriggeredJobRun
implements JsonSerializable<TriggeredJobRun> {
    private String webJobId;
    private String webJobName;
    private TriggeredWebJobStatus status;
    private OffsetDateTime startTime;
    private OffsetDateTime endTime;
    private String duration;
    private String outputUrl;
    private String errorUrl;
    private String url;
    private String jobName;
    private String trigger;

    public String webJobId() {
        return this.webJobId;
    }

    public TriggeredJobRun withWebJobId(String webJobId) {
        this.webJobId = webJobId;
        return this;
    }

    public String webJobName() {
        return this.webJobName;
    }

    public TriggeredJobRun withWebJobName(String webJobName) {
        this.webJobName = webJobName;
        return this;
    }

    public TriggeredWebJobStatus status() {
        return this.status;
    }

    public TriggeredJobRun withStatus(TriggeredWebJobStatus status) {
        this.status = status;
        return this;
    }

    public OffsetDateTime startTime() {
        return this.startTime;
    }

    public TriggeredJobRun withStartTime(OffsetDateTime startTime) {
        this.startTime = startTime;
        return this;
    }

    public OffsetDateTime endTime() {
        return this.endTime;
    }

    public TriggeredJobRun withEndTime(OffsetDateTime endTime) {
        this.endTime = endTime;
        return this;
    }

    public String duration() {
        return this.duration;
    }

    public TriggeredJobRun withDuration(String duration) {
        this.duration = duration;
        return this;
    }

    public String outputUrl() {
        return this.outputUrl;
    }

    public TriggeredJobRun withOutputUrl(String outputUrl) {
        this.outputUrl = outputUrl;
        return this;
    }

    public String errorUrl() {
        return this.errorUrl;
    }

    public TriggeredJobRun withErrorUrl(String errorUrl) {
        this.errorUrl = errorUrl;
        return this;
    }

    public String url() {
        return this.url;
    }

    public TriggeredJobRun withUrl(String url) {
        this.url = url;
        return this;
    }

    public String jobName() {
        return this.jobName;
    }

    public TriggeredJobRun withJobName(String jobName) {
        this.jobName = jobName;
        return this;
    }

    public String trigger() {
        return this.trigger;
    }

    public TriggeredJobRun withTrigger(String trigger) {
        this.trigger = trigger;
        return this;
    }

    public void validate() {
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("web_job_id", this.webJobId);
        jsonWriter.writeStringField("web_job_name", this.webJobName);
        jsonWriter.writeStringField("status", this.status == null ? null : this.status.toString());
        jsonWriter.writeStringField("start_time", this.startTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.startTime));
        jsonWriter.writeStringField("end_time", this.endTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.endTime));
        jsonWriter.writeStringField("duration", this.duration);
        jsonWriter.writeStringField("output_url", this.outputUrl);
        jsonWriter.writeStringField("error_url", this.errorUrl);
        jsonWriter.writeStringField("url", this.url);
        jsonWriter.writeStringField("job_name", this.jobName);
        jsonWriter.writeStringField("trigger", this.trigger);
        return jsonWriter.writeEndObject();
    }

    public static TriggeredJobRun fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            TriggeredJobRun deserializedTriggeredJobRun = new TriggeredJobRun();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("web_job_id".equals(fieldName)) {
                    deserializedTriggeredJobRun.webJobId = reader.getString();
                    continue;
                }
                if ("web_job_name".equals(fieldName)) {
                    deserializedTriggeredJobRun.webJobName = reader.getString();
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedTriggeredJobRun.status = TriggeredWebJobStatus.fromString(reader.getString());
                    continue;
                }
                if ("start_time".equals(fieldName)) {
                    deserializedTriggeredJobRun.startTime = reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                    continue;
                }
                if ("end_time".equals(fieldName)) {
                    deserializedTriggeredJobRun.endTime = reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                    continue;
                }
                if ("duration".equals(fieldName)) {
                    deserializedTriggeredJobRun.duration = reader.getString();
                    continue;
                }
                if ("output_url".equals(fieldName)) {
                    deserializedTriggeredJobRun.outputUrl = reader.getString();
                    continue;
                }
                if ("error_url".equals(fieldName)) {
                    deserializedTriggeredJobRun.errorUrl = reader.getString();
                    continue;
                }
                if ("url".equals(fieldName)) {
                    deserializedTriggeredJobRun.url = reader.getString();
                    continue;
                }
                if ("job_name".equals(fieldName)) {
                    deserializedTriggeredJobRun.jobName = reader.getString();
                    continue;
                }
                if ("trigger".equals(fieldName)) {
                    deserializedTriggeredJobRun.trigger = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedTriggeredJobRun;
        });
    }
}

