/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.authorization.fluent.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.CoreUtils;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphDirectoryObjectInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphExtension;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphScopedRoleMembership;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class MicrosoftGraphAdministrativeUnit
extends MicrosoftGraphDirectoryObjectInner {
    private String description;
    private String displayName;
    private String visibility;
    private List<MicrosoftGraphDirectoryObjectInner> members;
    private List<MicrosoftGraphScopedRoleMembership> scopedRoleMembers;
    private List<MicrosoftGraphExtension> extensions;
    private Map<String, Object> additionalProperties;

    public String description() {
        return this.description;
    }

    public MicrosoftGraphAdministrativeUnit withDescription(String description) {
        this.description = description;
        return this;
    }

    public String displayName() {
        return this.displayName;
    }

    public MicrosoftGraphAdministrativeUnit withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    public String visibility() {
        return this.visibility;
    }

    public MicrosoftGraphAdministrativeUnit withVisibility(String visibility) {
        this.visibility = visibility;
        return this;
    }

    public List<MicrosoftGraphDirectoryObjectInner> members() {
        return this.members;
    }

    public MicrosoftGraphAdministrativeUnit withMembers(List<MicrosoftGraphDirectoryObjectInner> members) {
        this.members = members;
        return this;
    }

    public List<MicrosoftGraphScopedRoleMembership> scopedRoleMembers() {
        return this.scopedRoleMembers;
    }

    public MicrosoftGraphAdministrativeUnit withScopedRoleMembers(List<MicrosoftGraphScopedRoleMembership> scopedRoleMembers) {
        this.scopedRoleMembers = scopedRoleMembers;
        return this;
    }

    public List<MicrosoftGraphExtension> extensions() {
        return this.extensions;
    }

    public MicrosoftGraphAdministrativeUnit withExtensions(List<MicrosoftGraphExtension> extensions) {
        this.extensions = extensions;
        return this;
    }

    @Override
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public MicrosoftGraphAdministrativeUnit withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @Override
    public MicrosoftGraphAdministrativeUnit withDeletedDateTime(OffsetDateTime deletedDateTime) {
        super.withDeletedDateTime(deletedDateTime);
        return this;
    }

    @Override
    public MicrosoftGraphAdministrativeUnit withId(String id) {
        super.withId(id);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.members() != null) {
            this.members().forEach(e -> e.validate());
        }
        if (this.scopedRoleMembers() != null) {
            this.scopedRoleMembers().forEach(e -> e.validate());
        }
        if (this.extensions() != null) {
            this.extensions().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id());
        jsonWriter.writeStringField("deletedDateTime", this.deletedDateTime() == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.deletedDateTime()));
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeStringField("displayName", this.displayName);
        jsonWriter.writeStringField("visibility", this.visibility);
        jsonWriter.writeArrayField("members", this.members, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        jsonWriter.writeArrayField("scopedRoleMembers", this.scopedRoleMembers, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        jsonWriter.writeArrayField("extensions", this.extensions, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        if (this.additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static MicrosoftGraphAdministrativeUnit fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MicrosoftGraphAdministrativeUnit deserializedMicrosoftGraphAdministrativeUnit = new MicrosoftGraphAdministrativeUnit();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedMicrosoftGraphAdministrativeUnit.withId(reader.getString());
                    continue;
                }
                if ("deletedDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphAdministrativeUnit.withDeletedDateTime(reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString())));
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedMicrosoftGraphAdministrativeUnit.description = reader.getString();
                    continue;
                }
                if ("displayName".equals(fieldName)) {
                    deserializedMicrosoftGraphAdministrativeUnit.displayName = reader.getString();
                    continue;
                }
                if ("visibility".equals(fieldName)) {
                    deserializedMicrosoftGraphAdministrativeUnit.visibility = reader.getString();
                    continue;
                }
                if ("members".equals(fieldName)) {
                    List<MicrosoftGraphDirectoryObjectInner> members = reader.readArray(reader1 -> MicrosoftGraphDirectoryObjectInner.fromJson(reader1));
                    deserializedMicrosoftGraphAdministrativeUnit.members = members;
                    continue;
                }
                if ("scopedRoleMembers".equals(fieldName)) {
                    List<MicrosoftGraphScopedRoleMembership> scopedRoleMembers = reader.readArray(reader1 -> MicrosoftGraphScopedRoleMembership.fromJson(reader1));
                    deserializedMicrosoftGraphAdministrativeUnit.scopedRoleMembers = scopedRoleMembers;
                    continue;
                }
                if ("extensions".equals(fieldName)) {
                    List<MicrosoftGraphExtension> extensions = reader.readArray(reader1 -> MicrosoftGraphExtension.fromJson(reader1));
                    deserializedMicrosoftGraphAdministrativeUnit.extensions = extensions;
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedMicrosoftGraphAdministrativeUnit.additionalProperties = additionalProperties;
            return deserializedMicrosoftGraphAdministrativeUnit;
        });
    }
}

