/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cdn.fluent.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cdn.models.CustomDomainHttpsParameters;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cdn.models.CustomDomainResourceState;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cdn.models.CustomHttpsProvisioningState;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cdn.models.CustomHttpsProvisioningSubstate;
import java.io.IOException;

public final class CustomDomainProperties
implements JsonSerializable<CustomDomainProperties> {
    private String hostname;
    private CustomDomainResourceState resourceState;
    private CustomHttpsProvisioningState customHttpsProvisioningState;
    private CustomHttpsProvisioningSubstate customHttpsProvisioningSubstate;
    private CustomDomainHttpsParameters customHttpsParameters;
    private String validationData;
    private CustomHttpsProvisioningState provisioningState;
    private static final ClientLogger LOGGER = new ClientLogger(CustomDomainProperties.class);

    public String hostname() {
        return this.hostname;
    }

    public CustomDomainProperties withHostname(String hostname) {
        this.hostname = hostname;
        return this;
    }

    public CustomDomainResourceState resourceState() {
        return this.resourceState;
    }

    public CustomHttpsProvisioningState customHttpsProvisioningState() {
        return this.customHttpsProvisioningState;
    }

    public CustomHttpsProvisioningSubstate customHttpsProvisioningSubstate() {
        return this.customHttpsProvisioningSubstate;
    }

    public CustomDomainHttpsParameters customHttpsParameters() {
        return this.customHttpsParameters;
    }

    public CustomDomainProperties withCustomHttpsParameters(CustomDomainHttpsParameters customHttpsParameters) {
        this.customHttpsParameters = customHttpsParameters;
        return this;
    }

    public String validationData() {
        return this.validationData;
    }

    public CustomDomainProperties withValidationData(String validationData) {
        this.validationData = validationData;
        return this;
    }

    public CustomHttpsProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public void validate() {
        if (this.hostname() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property hostname in model CustomDomainProperties"));
        }
        if (this.customHttpsParameters() != null) {
            this.customHttpsParameters().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("hostName", this.hostname);
        jsonWriter.writeJsonField("customHttpsParameters", this.customHttpsParameters);
        jsonWriter.writeStringField("validationData", this.validationData);
        return jsonWriter.writeEndObject();
    }

    public static CustomDomainProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            CustomDomainProperties deserializedCustomDomainProperties = new CustomDomainProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("hostName".equals(fieldName)) {
                    deserializedCustomDomainProperties.hostname = reader.getString();
                    continue;
                }
                if ("resourceState".equals(fieldName)) {
                    deserializedCustomDomainProperties.resourceState = CustomDomainResourceState.fromString(reader.getString());
                    continue;
                }
                if ("customHttpsProvisioningState".equals(fieldName)) {
                    deserializedCustomDomainProperties.customHttpsProvisioningState = CustomHttpsProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("customHttpsProvisioningSubstate".equals(fieldName)) {
                    deserializedCustomDomainProperties.customHttpsProvisioningSubstate = CustomHttpsProvisioningSubstate.fromString(reader.getString());
                    continue;
                }
                if ("customHttpsParameters".equals(fieldName)) {
                    deserializedCustomDomainProperties.customHttpsParameters = CustomDomainHttpsParameters.fromJson(reader);
                    continue;
                }
                if ("validationData".equals(fieldName)) {
                    deserializedCustomDomainProperties.validationData = reader.getString();
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedCustomDomainProperties.provisioningState = CustomHttpsProvisioningState.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCustomDomainProperties;
        });
    }
}

