/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cdn.fluent.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cdn.models.HealthProbeParameters;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cdn.models.ResourceReference;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cdn.models.ResponseBasedOriginErrorDetectionParameters;
import java.io.IOException;
import java.util.List;

public final class DeepCreatedOriginGroupProperties
implements JsonSerializable<DeepCreatedOriginGroupProperties> {
    private HealthProbeParameters healthProbeSettings;
    private List<ResourceReference> origins;
    private Integer trafficRestorationTimeToHealedOrNewEndpointsInMinutes;
    private ResponseBasedOriginErrorDetectionParameters responseBasedOriginErrorDetectionSettings;
    private static final ClientLogger LOGGER = new ClientLogger(DeepCreatedOriginGroupProperties.class);

    public HealthProbeParameters healthProbeSettings() {
        return this.healthProbeSettings;
    }

    public DeepCreatedOriginGroupProperties withHealthProbeSettings(HealthProbeParameters healthProbeSettings) {
        this.healthProbeSettings = healthProbeSettings;
        return this;
    }

    public List<ResourceReference> origins() {
        return this.origins;
    }

    public DeepCreatedOriginGroupProperties withOrigins(List<ResourceReference> origins) {
        this.origins = origins;
        return this;
    }

    public Integer trafficRestorationTimeToHealedOrNewEndpointsInMinutes() {
        return this.trafficRestorationTimeToHealedOrNewEndpointsInMinutes;
    }

    public DeepCreatedOriginGroupProperties withTrafficRestorationTimeToHealedOrNewEndpointsInMinutes(Integer trafficRestorationTimeToHealedOrNewEndpointsInMinutes) {
        this.trafficRestorationTimeToHealedOrNewEndpointsInMinutes = trafficRestorationTimeToHealedOrNewEndpointsInMinutes;
        return this;
    }

    public ResponseBasedOriginErrorDetectionParameters responseBasedOriginErrorDetectionSettings() {
        return this.responseBasedOriginErrorDetectionSettings;
    }

    public DeepCreatedOriginGroupProperties withResponseBasedOriginErrorDetectionSettings(ResponseBasedOriginErrorDetectionParameters responseBasedOriginErrorDetectionSettings) {
        this.responseBasedOriginErrorDetectionSettings = responseBasedOriginErrorDetectionSettings;
        return this;
    }

    public void validate() {
        if (this.healthProbeSettings() != null) {
            this.healthProbeSettings().validate();
        }
        if (this.origins() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property origins in model DeepCreatedOriginGroupProperties"));
        }
        this.origins().forEach(e -> e.validate());
        if (this.responseBasedOriginErrorDetectionSettings() != null) {
            this.responseBasedOriginErrorDetectionSettings().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("origins", this.origins, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        jsonWriter.writeJsonField("healthProbeSettings", this.healthProbeSettings);
        jsonWriter.writeNumberField("trafficRestorationTimeToHealedOrNewEndpointsInMinutes", this.trafficRestorationTimeToHealedOrNewEndpointsInMinutes);
        jsonWriter.writeJsonField("responseBasedOriginErrorDetectionSettings", this.responseBasedOriginErrorDetectionSettings);
        return jsonWriter.writeEndObject();
    }

    public static DeepCreatedOriginGroupProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DeepCreatedOriginGroupProperties deserializedDeepCreatedOriginGroupProperties = new DeepCreatedOriginGroupProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("origins".equals(fieldName)) {
                    List<ResourceReference> origins = reader.readArray(reader1 -> ResourceReference.fromJson(reader1));
                    deserializedDeepCreatedOriginGroupProperties.origins = origins;
                    continue;
                }
                if ("healthProbeSettings".equals(fieldName)) {
                    deserializedDeepCreatedOriginGroupProperties.healthProbeSettings = HealthProbeParameters.fromJson(reader);
                    continue;
                }
                if ("trafficRestorationTimeToHealedOrNewEndpointsInMinutes".equals(fieldName)) {
                    deserializedDeepCreatedOriginGroupProperties.trafficRestorationTimeToHealedOrNewEndpointsInMinutes = reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("responseBasedOriginErrorDetectionSettings".equals(fieldName)) {
                    deserializedDeepCreatedOriginGroupProperties.responseBasedOriginErrorDetectionSettings = ResponseBasedOriginErrorDetectionParameters.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDeepCreatedOriginGroupProperties;
        });
    }
}

