/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cdn.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cdn.models.AutoGeneratedDomainNameLabelScope;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cdn.models.ResourceType;
import java.io.IOException;

public final class CheckEndpointNameAvailabilityInput
implements JsonSerializable<CheckEndpointNameAvailabilityInput> {
    private String name;
    private ResourceType type;
    private AutoGeneratedDomainNameLabelScope autoGeneratedDomainNameLabelScope;
    private static final ClientLogger LOGGER = new ClientLogger(CheckEndpointNameAvailabilityInput.class);

    public String name() {
        return this.name;
    }

    public CheckEndpointNameAvailabilityInput withName(String name) {
        this.name = name;
        return this;
    }

    public ResourceType type() {
        return this.type;
    }

    public CheckEndpointNameAvailabilityInput withType(ResourceType type) {
        this.type = type;
        return this;
    }

    public AutoGeneratedDomainNameLabelScope autoGeneratedDomainNameLabelScope() {
        return this.autoGeneratedDomainNameLabelScope;
    }

    public CheckEndpointNameAvailabilityInput withAutoGeneratedDomainNameLabelScope(AutoGeneratedDomainNameLabelScope autoGeneratedDomainNameLabelScope) {
        this.autoGeneratedDomainNameLabelScope = autoGeneratedDomainNameLabelScope;
        return this;
    }

    public void validate() {
        if (this.name() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property name in model CheckEndpointNameAvailabilityInput"));
        }
        if (this.type() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property type in model CheckEndpointNameAvailabilityInput"));
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeStringField("autoGeneratedDomainNameLabelScope", this.autoGeneratedDomainNameLabelScope == null ? null : this.autoGeneratedDomainNameLabelScope.toString());
        return jsonWriter.writeEndObject();
    }

    public static CheckEndpointNameAvailabilityInput fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            CheckEndpointNameAvailabilityInput deserializedCheckEndpointNameAvailabilityInput = new CheckEndpointNameAvailabilityInput();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedCheckEndpointNameAvailabilityInput.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedCheckEndpointNameAvailabilityInput.type = ResourceType.fromString(reader.getString());
                    continue;
                }
                if ("autoGeneratedDomainNameLabelScope".equals(fieldName)) {
                    deserializedCheckEndpointNameAvailabilityInput.autoGeneratedDomainNameLabelScope = AutoGeneratedDomainNameLabelScope.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCheckEndpointNameAvailabilityInput;
        });
    }
}

