/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cdn.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cdn.models.QueryStringOperator;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cdn.models.Transform;
import java.io.IOException;
import java.util.List;

public final class QueryStringMatchConditionParameters
implements JsonSerializable<QueryStringMatchConditionParameters> {
    private String typeName = "DeliveryRuleQueryStringConditionParameters";
    private QueryStringOperator operator;
    private Boolean negateCondition;
    private List<String> matchValues;
    private List<Transform> transforms;
    private static final ClientLogger LOGGER = new ClientLogger(QueryStringMatchConditionParameters.class);

    public String typeName() {
        return this.typeName;
    }

    public QueryStringMatchConditionParameters withTypeName(String typeName) {
        this.typeName = typeName;
        return this;
    }

    public QueryStringOperator operator() {
        return this.operator;
    }

    public QueryStringMatchConditionParameters withOperator(QueryStringOperator operator) {
        this.operator = operator;
        return this;
    }

    public Boolean negateCondition() {
        return this.negateCondition;
    }

    public QueryStringMatchConditionParameters withNegateCondition(Boolean negateCondition) {
        this.negateCondition = negateCondition;
        return this;
    }

    public List<String> matchValues() {
        return this.matchValues;
    }

    public QueryStringMatchConditionParameters withMatchValues(List<String> matchValues) {
        this.matchValues = matchValues;
        return this;
    }

    public List<Transform> transforms() {
        return this.transforms;
    }

    public QueryStringMatchConditionParameters withTransforms(List<Transform> transforms) {
        this.transforms = transforms;
        return this;
    }

    public void validate() {
        if (this.operator() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property operator in model QueryStringMatchConditionParameters"));
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("typeName", this.typeName);
        jsonWriter.writeStringField("operator", this.operator == null ? null : this.operator.toString());
        jsonWriter.writeBooleanField("negateCondition", this.negateCondition);
        jsonWriter.writeArrayField("matchValues", this.matchValues, (writer, element) -> writer.writeString((String)element));
        jsonWriter.writeArrayField("transforms", this.transforms, (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        return jsonWriter.writeEndObject();
    }

    public static QueryStringMatchConditionParameters fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            QueryStringMatchConditionParameters deserializedQueryStringMatchConditionParameters = new QueryStringMatchConditionParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("operator".equals(fieldName)) {
                    deserializedQueryStringMatchConditionParameters.operator = QueryStringOperator.fromString(reader.getString());
                    continue;
                }
                if ("negateCondition".equals(fieldName)) {
                    deserializedQueryStringMatchConditionParameters.negateCondition = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("matchValues".equals(fieldName)) {
                    List<String> matchValues = reader.readArray(reader1 -> reader1.getString());
                    deserializedQueryStringMatchConditionParameters.matchValues = matchValues;
                    continue;
                }
                if ("transforms".equals(fieldName)) {
                    List<Transform> transforms = reader.readArray(reader1 -> Transform.fromString(reader1.getString()));
                    deserializedQueryStringMatchConditionParameters.transforms = transforms;
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedQueryStringMatchConditionParameters;
        });
    }
}

