/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cdn.models;

import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cdn.models.Algorithm;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cdn.models.UrlSigningParamIdentifier;
import java.io.IOException;
import java.util.List;

public final class UrlSigningActionParameters
implements JsonSerializable<UrlSigningActionParameters> {
    private String typeName = "DeliveryRuleUrlSigningActionParameters";
    private Algorithm algorithm;
    private List<UrlSigningParamIdentifier> parameterNameOverride;

    public String typeName() {
        return this.typeName;
    }

    public UrlSigningActionParameters withTypeName(String typeName) {
        this.typeName = typeName;
        return this;
    }

    public Algorithm algorithm() {
        return this.algorithm;
    }

    public UrlSigningActionParameters withAlgorithm(Algorithm algorithm) {
        this.algorithm = algorithm;
        return this;
    }

    public List<UrlSigningParamIdentifier> parameterNameOverride() {
        return this.parameterNameOverride;
    }

    public UrlSigningActionParameters withParameterNameOverride(List<UrlSigningParamIdentifier> parameterNameOverride) {
        this.parameterNameOverride = parameterNameOverride;
        return this;
    }

    public void validate() {
        if (this.parameterNameOverride() != null) {
            this.parameterNameOverride().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("typeName", this.typeName);
        jsonWriter.writeStringField("algorithm", this.algorithm == null ? null : this.algorithm.toString());
        jsonWriter.writeArrayField("parameterNameOverride", this.parameterNameOverride, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        return jsonWriter.writeEndObject();
    }

    public static UrlSigningActionParameters fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            UrlSigningActionParameters deserializedUrlSigningActionParameters = new UrlSigningActionParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("algorithm".equals(fieldName)) {
                    deserializedUrlSigningActionParameters.algorithm = Algorithm.fromString(reader.getString());
                    continue;
                }
                if ("parameterNameOverride".equals(fieldName)) {
                    List<UrlSigningParamIdentifier> parameterNameOverride = reader.readArray(reader1 -> UrlSigningParamIdentifier.fromJson(reader1));
                    deserializedUrlSigningActionParameters.parameterNameOverride = parameterNameOverride;
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedUrlSigningActionParameters;
        });
    }
}

